package org.mule.coverage.printer.model;

import org.mule.munit.plugins.coverage.report.model.MuleFlow;

public class MuleFlowModel {

    private String name;
    private double coverage;
    private int messageProcessorCount;
    private int coveredMessageProcessorCount;

    public MuleFlowModel(MuleFlow flow) {
        this.coverage = flow.getCoverage();
        this.name = flow.getName();
        this.messageProcessorCount = flow.getPaths().size();
        this.coveredMessageProcessorCount = flow.getCoveredPaths().size();
    }

    public double getCoverage() {
        return coverage;
    }

    public String getName() {
        return name;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMessageProcessorCount() {
        return messageProcessorCount;
    }

    public void setMessageProcessorCount(int messageProcessorCount) {
        this.messageProcessorCount = messageProcessorCount;
    }

    public int getCoveredMessageProcessorCount() {
        return coveredMessageProcessorCount;
    }

    public void setCoveredMessageProcessorCount(int coveredMessageProcessorCount) {
        this.coveredMessageProcessorCount = coveredMessageProcessorCount;
    }
}
