package org.mule.runner.printer;


import org.apache.maven.plugin.logging.Log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public abstract class FileResultPrinter implements ResultPrinter {

    protected File suitesBasePath;
    protected File reportBasePath;
    protected Log log;

    public FileResultPrinter(File reportBasePath, File suitesBasePath, Log log) {
        this.reportBasePath = reportBasePath;
        this.suitesBasePath = suitesBasePath;
        this.log = log;
    }

    public PrintStream getResultPrintStream(String fileName) throws FileNotFoundException {
        File file = new File(reportBasePath, fileName);
        createFolderIfNotExists(file.getParentFile());
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        return printStream;
    }

    private void createFolderIfNotExists(File parentFile) throws FileNotFoundException {
        boolean success = true;
        if (!parentFile.exists()) {
            success = parentFile.mkdirs();
        }
        if (!success) {
            throw new FileNotFoundException("Unable to create directory " + parentFile);
        }
    }

    public String getSuiteRelativePath(String suitePath) {
        File suiteFile = new File(suitePath);
        String relative = suitesBasePath.toURI().relativize(suiteFile.toURI()).getPath();
        return relative;
    }

}
