/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.printer;

import org.apache.maven.plugin.logging.Log;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class ConsolePrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "Console";
    private Log log;

    public ConsolePrinter(Log log) {
        this.log = log;
    }

    public String getPrinterName() {
        return PRINTER_NAME;
    }

    public void printReport(ApplicationCoverageReport report) {
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"\t\t\t\tMUnit Coverage Report");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"");
        for (MuleResource mr : report.getResources()) {
            this.log.info((CharSequence)"-------------------------------------------------------------------------------");
            if (mr.getCoverage() != -1.0) {
                this.log.info((CharSequence)("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " - Weight: " + String.format("%.2f", mr.getWeight()) + " -  Coverage: " + mr.getCoverage() + "%"));
            } else {
                this.log.info((CharSequence)("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " - Weight: " + String.format("%.2f", mr.getWeight()) + " -  Coverage: N/A"));
            }
            this.log.info((CharSequence)"-------------------------------------------------------------------------------");
            for (MuleFlow mf : mr.getFlows()) {
                this.log.info((CharSequence)("  * Flow:" + mf.getName() + " - Covered (MP): " + mr.getCoveredMessageProcessorCount() + " - Total (MP): " + mr.getMessageProcessorCount() + " - Coverage: " + mf.getCoverage() + "%"));
            }
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"\t\t\t\t\tSummary");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)("  * CMPs: " + report.getApplicationCoveredMessageProcessorCount()));
        this.log.info((CharSequence)("  * MPs: " + report.getApplicationMessageProcessorCount()));
        this.log.info((CharSequence)("  * Flows: " + report.getApplicationFlowCount()));
        this.log.info((CharSequence)("  * Resources: " + report.getResources().size()));
        this.log.info((CharSequence)"===============================================================================");
        if (report.getApplicationFlowCount() > 0) {
            this.log.info((CharSequence)("\t\t\t\t** Application Coverage: " + String.format("%.2f", report.getCoverage()) + "% **"));
        } else {
            this.log.info((CharSequence)"\t\t\t\t** Application Coverage: N/A **");
        }
        this.log.info((CharSequence)"===============================================================================");
    }
}

