/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage.printer;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class SummaryConsolePrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "summaryconsole";
    private Double requiredApplicationCoverage = Double.valueOf("-1");
    private Double requiredResourceCoverage = Double.valueOf("-1");
    private Double requiredFlowCoverage = Double.valueOf("-1");
    private Boolean failBuild = false;
    private Log log;

    public SummaryConsolePrinter(Log log) {
        this.log = log;
    }

    public void setRequiredApplicationCoverage(Double requiredApplicationCoverage) {
        this.requiredApplicationCoverage = requiredApplicationCoverage;
    }

    public void setRequiredResourceCoverage(Double requiredResourceCoverage) {
        this.requiredResourceCoverage = requiredResourceCoverage;
    }

    public void setRequiredFlowCoverage(Double requiredFlowCoverage) {
        this.requiredFlowCoverage = requiredFlowCoverage;
    }

    public void setFailBuild(Boolean failBuild) {
        this.failBuild = failBuild;
    }

    public String getPrinterName() {
        return PRINTER_NAME;
    }

    private String formatCoverage(Double coverage) {
        DecimalFormat formatter = new DecimalFormat("#00.00");
        return formatter.format(coverage);
    }

    public void printReport(ApplicationCoverageReport report) {
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"MUnit Coverage Summary");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)(" * Resources: " + report.getResources().size() + " - Flows: " + report.getApplicationFlowCount() + " - Message Processors: " + report.getApplicationMessageProcessorCount()));
        if (report.getApplicationFlowCount() > 0) {
            this.log.info((CharSequence)(" * Application Coverage: " + this.formatCoverage(report.getCoverage()) + "%"));
        } else {
            this.log.info((CharSequence)" * Application Coverage: N/A");
        }
        this.printCoverageWarnings(report);
    }

    private void printCoverageWarnings(ApplicationCoverageReport report) {
        block10: {
            ArrayList<String> warnings = new ArrayList<String>();
            if (this.requiredApplicationCoverage != -1.0 && report.getApplicationFlowCount() > 0 && report.getCoverage() < this.requiredApplicationCoverage) {
                warnings.add(" * Application coverage is below defined limit. Required: " + this.requiredApplicationCoverage + "% - Current: " + this.formatCoverage(report.getCoverage()) + "%");
            }
            if (this.requiredResourceCoverage != -1.0) {
                for (MuleResource mr : report.getResources()) {
                    if (mr.getCoverage() == -1.0 || !(mr.getCoverage() < this.requiredResourceCoverage)) continue;
                    warnings.add(" * Resource " + mr.getName() + " coverage is below defined limit. Required: " + this.requiredResourceCoverage + "% - Current: " + this.formatCoverage(mr.getCoverage()) + "%");
                }
            }
            if (this.requiredFlowCoverage != -1.0) {
                for (MuleResource mr : report.getResources()) {
                    for (MuleFlow mf : mr.getFlows()) {
                        if (!(mf.getCoverage() < this.requiredFlowCoverage)) continue;
                        warnings.add(" * Flow: " + mr.getName() + " -> " + mf.getName() + " coverage is below defined limit. Required: " + this.requiredFlowCoverage + "% - Current: " + this.formatCoverage(mf.getCoverage()) + "%");
                    }
                }
            }
            if (warnings.isEmpty()) break block10;
            this.log.info((CharSequence)"");
            if (!this.failBuild.booleanValue()) {
                this.log.warn((CharSequence)"----------------------------- WARNING --------------------------------------");
                for (String w : warnings) {
                    this.log.warn((CharSequence)w);
                }
            } else {
                this.log.error((CharSequence)"------------------------------ FAILURE ---------------------------------------");
                for (String w : warnings) {
                    this.log.error((CharSequence)w);
                }
            }
        }
    }
}

