/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.printer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.runner.model.RunResult;
import org.mule.runner.model.SuiteResult;
import org.mule.runner.model.TestResult;
import org.mule.runner.printer.FileResultPrinter;
import org.mule.runner.printer.xml.CdataAwareXppDriver;
import org.mule.runner.printer.xml.Property;
import org.mule.runner.printer.xml.TestCase;
import org.mule.runner.printer.xml.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResultPrinter
extends FileResultPrinter {
    private static final float MILLIS_FACTOR = 1000.0f;
    private static final String XML_REPORT_HEADER = "TEST-munit.";
    private TestSuite suite;
    private String name;
    private Map<String, String> systemProperties;

    public XmlResultPrinter(File reportBasePath, File suiteBasePath, File projectBasePath, Map<String, String> systemProperties, Log log) {
        super(reportBasePath, suiteBasePath, projectBasePath, log);
        this.systemProperties = systemProperties;
    }

    @Override
    public void print(RunResult runResult) {
        try {
            for (SuiteResult suiteResult : runResult.getSuites()) {
                this.printSuiteResult(suiteResult);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void printSuiteResult(SuiteResult result) throws FileNotFoundException {
        CdataAwareXppDriver xppDriver = new CdataAwareXppDriver();
        XStream xStream = new XStream((HierarchicalStreamDriver)xppDriver);
        xStream.autodetectAnnotations(true);
        this.name = FilenameUtils.getName((String)result.getSuitePath()).replace(".xml", "");
        this.suite = new TestSuite(this.dumpProperties(System.getProperties(), this.systemProperties), this.name);
        for (TestResult testResult : result.getTests()) {
            this.printTestResult(testResult);
        }
        this.suite.setErrors(result.getNumberOfErrors());
        this.suite.setFailures(result.getNumberOfFailures());
        this.suite.setTests(result.getNumberOfTests());
        this.suite.setTime((float)result.getTime() / 1000.0f);
        this.suite.setSkipped(result.getNumberOfIgnores());
        String suiteRelativePath = this.getSuiteRelativePath(result.getSuitePath());
        String suiteReportName = suiteRelativePath.replace("/", ".");
        PrintStream out = this.getResultPrintStream(XML_REPORT_HEADER + suiteReportName);
        out.print(xStream.toXML((Object)this.suite));
    }

    public void printTestResult(TestResult testResult) {
        TestCase testCase = new TestCase((float)testResult.getTime() / 1000.0f, this.name, testResult.getTestName());
        testCase.setSkipped(testResult.isIgnored());
        if (testResult.hasFailed()) {
            testCase.setFailure(testResult.getCause());
        }
        if (testResult.hasError()) {
            testCase.setError(testResult.getCause());
        }
        this.suite.add(testCase);
    }

    private List<Property> dumpProperties(Properties properties, Map<String, String> sysProps) {
        ArrayList<Property> testProperties = new ArrayList<Property>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (sysProps.containsKey(entry.getKey())) continue;
            testProperties.add(new Property((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            testProperties.add(new Property((String)entry.getKey(), (String)entry.getValue()));
        }
        return testProperties;
    }
}

