/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.mule.munit.remote.notification.MessageHandlerMode;
import org.mule.runner.StartupConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMStarter {
    public static final String ARG_TOKEN = "-";
    private static final String TEST_NAME_ARG = "-test_name";
    private static final String RUN_TOKEN_ARG = "-run_token";
    private static final String RUN_COVERAGE_ARG = "-run_coverage";
    private static final String PROJECT_NAME_ARG = "-project_name";
    private static final String MODE_ARG = "-mode";
    private static final String APPLICATION_PATHS_ARG = "-application_paths";
    private static final String IGNORE_FLOWS_ARG = "-ignore_flows";
    private static final String RUNNER_MODE = MessageHandlerMode.CONSOLE.toString();
    private static final String STARTER_CLASS_FILE = "munitstarter";
    private static final String MANIFEST_VERSION = "1.0";
    private Log log;
    private Commandline commandline = new Commandline();

    public JVMStarter(StartupConfiguration startupConfiguration, Log log) throws IOException {
        Validate.notNull((Object)startupConfiguration);
        this.log = log;
        this.createJVMArgs(startupConfiguration);
        this.createRunnerArgs(startupConfiguration);
    }

    public int execute(StreamConsumer streamConsumer) throws CommandLineException {
        return this.execute(streamConsumer, streamConsumer);
    }

    public int execute(StreamConsumer outStreamConsumer, StreamConsumer errStreamConsumer) throws CommandLineException {
        this.log.debug((CharSequence)("Executing command line: " + this.commandline));
        return CommandLineUtils.executeCommandLine((Commandline)this.commandline, (StreamConsumer)outStreamConsumer, (StreamConsumer)errStreamConsumer);
    }

    private void createJVMArgs(StartupConfiguration startupConfiguration) throws IOException {
        File jarFile = this.createJar(startupConfiguration.getClasspath(), startupConfiguration.getClassName(), startupConfiguration.getBuildDirectory());
        this.commandline.setExecutable(startupConfiguration.getJvm());
        this.commandline.createArg().setValue("-jar");
        this.commandline.createArg().setValue(jarFile.getAbsolutePath());
        this.commandline.setWorkingDirectory(startupConfiguration.getWorkingDirectory());
        this.addSystemProperties(startupConfiguration);
        this.addArgLines(startupConfiguration);
        this.addEnvironmentVariables(startupConfiguration);
    }

    private void addArgLines(StartupConfiguration startupConfiguration) {
        if (startupConfiguration.getArgLines() != null) {
            for (String argLine : startupConfiguration.getArgLines()) {
                this.commandline.createArg(true).setValue(argLine);
            }
        }
    }

    private void addSystemProperties(StartupConfiguration startupConfig) {
        if (startupConfig.getSystemProperties() != null) {
            for (Map.Entry<String, String> sysProp : startupConfig.getSystemProperties().entrySet()) {
                this.commandline.createArg(true).setValue("-D" + sysProp.getKey() + "=" + sysProp.getValue());
            }
        }
    }

    private void addEnvironmentVariables(StartupConfiguration startupConfig) {
        if (startupConfig.getEnvironmentVariables() != null) {
            for (Map.Entry<String, String> envProp : startupConfig.getEnvironmentVariables().entrySet()) {
                this.commandline.addEnvironment(envProp.getKey(), envProp.getValue());
            }
        }
    }

    private void createRunnerArgs(StartupConfiguration startupConfiguration) {
        this.commandline.addEnvironment("munit.suites", this.buildSuiteArgs(startupConfiguration.getSuites(), startupConfiguration.getWorkingDirectory()));
        this.commandline.createArg().setValue(RUN_TOKEN_ARG);
        this.commandline.createArg().setValue(startupConfiguration.getRunToken());
        this.commandline.createArg().setValue(PROJECT_NAME_ARG);
        this.commandline.createArg().setValue(startupConfiguration.getProjectName());
        this.commandline.createArg().setValue(MODE_ARG);
        this.commandline.createArg().setValue(RUNNER_MODE);
        if (StringUtils.isNotEmpty((String)startupConfiguration.getTest())) {
            this.commandline.createArg().setValue(TEST_NAME_ARG);
            this.commandline.createArg().setValue(startupConfiguration.getTest());
        }
        this.createCoverageRunnerArgs(startupConfiguration);
    }

    private void createCoverageRunnerArgs(StartupConfiguration startupConfiguration) {
        if (startupConfiguration.isRunCoverage().booleanValue()) {
            this.commandline.createArg().setValue(RUN_COVERAGE_ARG);
            this.commandline.createArg().setValue(APPLICATION_PATHS_ARG);
            this.commandline.createArg().setValue(startupConfiguration.getApplicationPaths());
            if (!startupConfiguration.getIgnoreFlows().isEmpty()) {
                this.commandline.createArg().setValue(IGNORE_FLOWS_ARG);
                this.commandline.createArg().setValue(this.buildIgnoreFlowsArg(startupConfiguration.getIgnoreFlows()));
            }
        }
    }

    private String buildSuiteArgs(List<File> suites, File workingDirectory) {
        StringBuilder stringBuilder = new StringBuilder();
        String separator = "";
        for (File suiteFile : suites) {
            stringBuilder.append(separator);
            separator = ",";
            stringBuilder.append(workingDirectory.toURI().relativize(suiteFile.toURI()).getPath());
        }
        return stringBuilder.toString();
    }

    private String buildIgnoreFlowsArg(Set<String> ignoreFlows) {
        StringBuilder stringBuilder = new StringBuilder();
        String separator = "";
        for (String flow : ignoreFlows) {
            stringBuilder.append(separator);
            separator = ",";
            stringBuilder.append(flow);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createJar(List<String> classPath, String startClassName, String buildDirectory) throws IOException {
        File tempDirectory = new File(buildDirectory);
        File file = File.createTempFile(STARTER_CLASS_FILE, ".jar", tempDirectory);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        try {
            jarOutputStream.setLevel(0);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry(je);
            Manifest manifest = new Manifest();
            StringBuilder cp = new StringBuilder();
            for (String el : classPath) {
                cp.append(new File(el).toURI().toURL().toExternalForm()).append(" ");
            }
            manifest.getMainAttributes().putValue("Manifest-Version", MANIFEST_VERSION);
            manifest.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            manifest.getMainAttributes().putValue("Main-Class", startClassName);
            manifest.write(jarOutputStream);
        }
        finally {
            jarOutputStream.close();
        }
        return file;
    }
}

