/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

import java.util.ArrayList;
import java.util.List;

/**
 * This class define the configuration of the coverage functionality
 */
public class Coverage {

    private Boolean runCoverage = false;

    private Boolean failBuild = false;

    private Double requiredApplicationCoverage = Double.valueOf("-1");
    private Double requiredResourceCoverage = Double.valueOf("-1");
    private Double requiredFlowCoverage = Double.valueOf("-1");

    private List<String> ignoreFlows = new ArrayList<String>();

    private List<String> formats = new ArrayList();

    public Boolean shouldRunCoverage() {
        return runCoverage;
    }

    public Boolean getRunCoverage() {
        return runCoverage;
    }

    public void setRunCoverage(Boolean runCoverage) {
        this.runCoverage = runCoverage;
    }

    public Boolean getFailBuild() {
        return failBuild;
    }

    public void setFailBuild(Boolean failBuild) {
        this.failBuild = failBuild;
    }

    public Double getRequiredApplicationCoverage() {
        return requiredApplicationCoverage;
    }

    public void setRequiredApplicationCoverage(Double requiredApplicationCoverage) {
        this.requiredApplicationCoverage = requiredApplicationCoverage;
    }

    public Double getRequiredResourceCoverage() {
        return requiredResourceCoverage;
    }

    public void setRequiredResourceCoverage(Double requiredResourceCoverage) {
        this.requiredResourceCoverage = requiredResourceCoverage;
    }

    public Double getRequiredFlowCoverage() {
        return requiredFlowCoverage;
    }

    public void setRequiredFlowCoverage(Double requiredFlowCoverage) {
        this.requiredFlowCoverage = requiredFlowCoverage;
    }

    public List<String> getFormats() {
        return formats;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public List<String> getIgnoreFlows() {
        return ignoreFlows;
    }

    public void setIgnoreFlows(List<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }
}
