/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MuleRuntimeDetector {

    private List<String> classpath = new ArrayList<String>();
    protected static final String MULE_CORE_ENTRY = "com" + File.separator + "mulesoft" + File.separator +
            "muleesb" + File.separator + "mule-core-ee";

    /**
     * The purpose of this method is to check if classes inside the jar mule-core-ee can be loaded.
     * If they can it's taken as a token that it's being run over a EE.
     * If such jar is not in the classpath then it's considered it's being run over a CE runtime.
     *
     * @return true is the flag class can be loaded
     */
    public boolean isRunningOnEE() {
        for (String entry : classpath) {
            if (entry.contains(MULE_CORE_ENTRY)) {
                return true;
            }
        }
        return false;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
    }
}