package org.mule.runner;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;

public class RunnerMessage {

    private String messageId;
    private String runToken;
    private String suitePath;
    private String suiteName;
    private String testName;
    private String freeMessage;
    private String stackTrace;
    private String jsonMessage;

    public RunnerMessage(String msg, String separator, String newLineToken) {
        List<String> fields = Arrays.asList(StringUtils.split(msg,separator));

        if (isValidMessage(msg, separator)) {
          this.messageId = fields.get(0);
          this.runToken = fields.get(1);
          this.suitePath = fields.get(2);
          this.suiteName = fields.get(3);
          this.testName = fields.get(4);
          this.freeMessage = fields.get(5);
          this.stackTrace = fields.get(6).replaceAll(newLineToken, "\n");
          this.jsonMessage = fields.get(7);
        }
    }

    public String getMessageId() {
        return messageId;
    }

    public String getRunToken() {
        return runToken;
    }

    public String getSuitePath() {
        return suitePath;
    }

    public String getSuiteName() {
        return suiteName;
    }

    public String getTestName() {
        return testName;
    }

    public String getFreeMessage() {
        return freeMessage;
    }

    public String getStackTrace() {
        return stackTrace;
    }

    public String getJsonMessage() {
        return jsonMessage;
    }

    public String getSuiteFullPath() {
        return getSuitePath() + getSuiteName();
    }

    @Override
    public String toString() {
        return getMessageId() + "-" + getRunToken() + "-" + getSuitePath() + "-" + getTestName() + "-" + getJsonMessage();
    }

    public static boolean isValidMessage(String msg, String separator) {
      List<String> fields = Arrays.asList(StringUtils.split(msg, separator));

      return fields.size() == 8;
    }
}
