package org.mule.runner;


import java.io.File;
import java.util.*;

public class StartupConfiguration {

    public List<File> suites = new ArrayList<File>();
    private String buildDirectory;
    private String className;
    private String test;
    private String runToken;
    private String projectName;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> environmentVariables;
    private List<String> classpath = new ArrayList<String>();
    private Boolean runCoverage;
    private String applicationPaths;
    private Set<String> ignoreFlows;
    private File workingDirectory;
    private String jvm;
    private List<String> argLines;

    public List<File> getSuites() {
        return suites;
    }

    public String getRunToken() {
        return runToken;
    }

    public String getTest() {
        return test;
    }

    public List<String> getClasspath() {
        return classpath;
    }

    public Map<String, String> getSystemProperties() {
        return systemProperties;
    }

    public String getBuildDirectory() {
        return buildDirectory;
    }

    public String getClassName() {
        return className;
    }

    public String getApplicationPaths() {
        return applicationPaths;
    }

    public Boolean isRunCoverage() {
        return runCoverage;
    }

    public String getProjectName() {
        return projectName;
    }

    public Set<String> getIgnoreFlows() {
        return ignoreFlows;
    }

    public File getWorkingDirectory() {
        return workingDirectory;
    }

    public String getJvm() {
        return jvm;
    }

    public List<String> getArgLines() {
        return argLines;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
    }

    public void setRunToken(String runToken) {
        this.runToken = runToken;
    }

    public void setSuites(List<File> suites) {
        this.suites = suites;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public void setBuildDirectory(String buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setRunCoverage(Boolean runCoverage) {
        this.runCoverage = runCoverage;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setApplicationPaths(String applicationPaths) {
        this.applicationPaths = applicationPaths;
    }

    public void setIgnoreFlows(Set<String> ignoreFlows) {
        this.ignoreFlows = ignoreFlows;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setArgLines(List<String> argLines) {
        this.argLines = argLines;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Map<String, String> getEnvironmentVariables() {
        return environmentVariables;
    }
}
