/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runner.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteResult {
    private String suitePath;
    private int numberOfTests;
    private boolean suiteFinished = false;
    private boolean runtimeStartFailed = false;
    private String cause;
    private Map<String, TestResult> tests = new HashMap<String, TestResult>();
    private long time;
    private boolean suiteFailed;
    private boolean suiteError;

    public void setRuntimeStartFailed(boolean runtimeStartFailed) {
        this.runtimeStartFailed = runtimeStartFailed;
    }

    public void setCause(String newCause) {
        if (StringUtils.isEmpty((CharSequence)this.cause)) {
            this.cause = newCause;
        }
    }

    public void add(String testName, TestResult testResult) {
        this.tests.put(testName, testResult);
    }

    public void setSuitePath(String suitePath) {
        this.suitePath = suitePath;
    }

    public void setSuiteFinished(boolean suiteFinished) {
        this.suiteFinished = suiteFinished;
    }

    public boolean isSuiteFinished() {
        return this.suiteFinished;
    }

    public boolean isRuntimeStartFailed() {
        return this.runtimeStartFailed;
    }

    public String getCause() {
        return this.cause;
    }

    public int getNumberOfProcessedTests() {
        int count = 0;
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.isFinished()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfIgnores() {
        int ignores = 0;
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.isIgnored()) continue;
            ++ignores;
        }
        return ignores;
    }

    public int getNumberOfFailures() {
        int failures = 0;
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.hasFailed()) continue;
            ++failures;
        }
        return failures;
    }

    public int getNumberOfErrors() {
        int errors = 0;
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.hasError()) continue;
            ++errors;
        }
        return errors;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public void setNumberOfTests(int valueOf) {
        this.numberOfTests = valueOf;
    }

    public TestResult getTest(String string) {
        return this.tests.get(string);
    }

    public TestResult getRunningTest() {
        for (TestResult testResult : this.tests.values()) {
            if (testResult.isFinished()) continue;
            return testResult;
        }
        return null;
    }

    public Collection<TestResult> getTests() {
        return this.tests.values();
    }

    public String getSuitePath() {
        return this.suitePath;
    }

    public boolean hasFailed() {
        if (this.suiteFailed) {
            return true;
        }
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.hasFailed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        if (this.runtimeStartFailed || this.suiteError) {
            return true;
        }
        for (TestResult testResult : this.tests.values()) {
            if (!testResult.hasError()) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored() {
        if (this.tests.isEmpty()) {
            return false;
        }
        for (TestResult testResult : this.tests.values()) {
            if (testResult.isIgnored()) continue;
            return false;
        }
        return true;
    }

    public List<TestResult> getFailingTests() {
        ArrayList<TestResult> failingTests = new ArrayList<TestResult>();
        for (TestResult test : this.getTests()) {
            if (!test.hasFailed()) continue;
            failingTests.add(test);
        }
        return failingTests;
    }

    public List<TestResult> getErrorTests() {
        ArrayList<TestResult> errorTests = new ArrayList<TestResult>();
        for (TestResult test : this.getTests()) {
            if (!test.hasError()) continue;
            errorTests.add(test);
        }
        return errorTests;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setSuiteFailed(boolean suiteFailed) {
        this.suiteFailed = suiteFailed;
    }

    public boolean isSuiteFailed() {
        return this.suiteFailed;
    }

    public void setSuiteError(boolean suiteError) {
        this.suiteError = suiteError;
    }

    public boolean isSuiteError() {
        return this.suiteError;
    }
}

