/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RunnerMessage {
    private String messageId;
    private String runToken;
    private String suitePath;
    private String suiteName;
    private String testName;
    private String freeMessage;
    private String stackTrace;
    private String jsonMessage;

    public RunnerMessage(String msg, String separator, String newLineToken) {
        List<String> fields = Arrays.asList(StringUtils.split((String)msg, (String)separator));
        if (RunnerMessage.isValidMessage(msg, separator)) {
            this.messageId = fields.get(0);
            this.runToken = fields.get(1);
            this.suitePath = fields.get(2);
            this.suiteName = fields.get(3);
            this.testName = fields.get(4);
            this.freeMessage = fields.get(5);
            this.stackTrace = fields.get(6).replaceAll(newLineToken, "\n");
            this.jsonMessage = fields.get(7);
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRunToken() {
        return this.runToken;
    }

    public String getSuitePath() {
        return this.suitePath;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getFreeMessage() {
        return this.freeMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getJsonMessage() {
        return this.jsonMessage;
    }

    public String getSuiteFullPath() {
        return this.getSuitePath() + this.getSuiteName();
    }

    public String toString() {
        return this.getMessageId() + "-" + this.getRunToken() + "-" + this.getSuitePath() + "-" + this.getTestName() + "-" + this.getJsonMessage();
    }

    public static boolean isValidMessage(String msg, String separator) {
        List<String> fields = Arrays.asList(StringUtils.split((String)msg, (String)separator));
        return fields.size() == 8;
    }
}

