/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;

public class MulePropertiesLoader {
    private static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";
    private transient Log log;
    private String classesPath;
    private String testClassesPath;

    public MulePropertiesLoader(String classesPath, String testClassesPath, Log log) {
        this.log = log;
        this.classesPath = classesPath;
        this.testClassesPath = testClassesPath;
    }

    public String getConfigResources() {
        Properties props = this.loadProperties();
        if (props != null && props.getProperty("config.resources") != null) {
            return props.getProperty("config.resources");
        }
        return "";
    }

    private Properties loadProperties() {
        try {
            Properties prop = new Properties();
            URL muleDeployPropertiesUrl = this.findMuleDeployProperties();
            if (null == muleDeployPropertiesUrl) {
                return null;
            }
            InputStream in = muleDeployPropertiesUrl.openStream();
            prop.load(in);
            in.close();
            return prop;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private URL findMuleDeployProperties() throws IOException {
        URL muleDeployPropertiesUrl = null;
        File classesFile = new File(this.classesPath, MULE_DEPLOY_PROPERTIES);
        File testClassesFile = new File(this.testClassesPath, MULE_DEPLOY_PROPERTIES);
        if (classesFile.exists()) {
            muleDeployPropertiesUrl = classesFile.toURI().toURL();
        } else if (testClassesFile.exists()) {
            muleDeployPropertiesUrl = testClassesFile.toURI().toURL();
        }
        if (null == muleDeployPropertiesUrl) {
            this.log.debug((CharSequence)"Failed to find mule-deploy.properties file");
        } else {
            this.log.debug((CharSequence)("Found mule-deploy.properties file at: " + muleDeployPropertiesUrl.getPath()));
        }
        return muleDeployPropertiesUrl;
    }
}

