package org.mule.runner.model;


import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class SuiteResult {

    private String suitePath;
    private int numberOfTests;

    private boolean suiteFinished = false;
    private boolean runtimeStartFailed = false;

    private String cause;
    private Map<String, TestResult> tests = new HashMap<String, TestResult>();
    private long time;
    private boolean suiteFailed;
    private boolean suiteError;

    public void setRuntimeStartFailed(boolean runtimeStartFailed) {
        this.runtimeStartFailed = runtimeStartFailed;
    }

    public void setCause(String newCause) {
        if (StringUtils.isEmpty(cause)) {
            this.cause = newCause;
        }
    }

    public void add(String testName, TestResult testResult) {
        tests.put(testName, testResult);
    }

    public void setSuitePath(String suitePath) {
        this.suitePath = suitePath;
    }

    public void setSuiteFinished(boolean suiteFinished) {
        this.suiteFinished = suiteFinished;
    }

    public boolean isSuiteFinished() {
        return suiteFinished;
    }

    public boolean isRuntimeStartFailed() {
        return runtimeStartFailed;
    }

    public String getCause() {
        return cause;
    }

    public int getNumberOfProcessedTests() {
        int count = 0;
        for (TestResult testResult : tests.values()) {
            if (testResult.isFinished()) {
                count++;
            }
        }
        return count;
    }

    public int getNumberOfIgnores() {
        int ignores = 0;
        for (TestResult testResult : tests.values()) {
            if (testResult.isIgnored()) {
                ignores++;
            }
        }
        return ignores;
    }

    public int getNumberOfFailures() {
        int failures = 0;
        for (TestResult testResult : tests.values()) {
            if (testResult.hasFailed()) {
                failures++;
            }
        }
        return failures;
    }

    public int getNumberOfErrors() {
        int errors = 0;
        for (TestResult testResult : tests.values()) {
            if (testResult.hasError()) {
                errors++;
            }
        }
        return errors;
    }

    public int getNumberOfTests() {
        return numberOfTests;
    }

    public void setNumberOfTests(int valueOf) {
        numberOfTests = valueOf;

    }

    public TestResult getTest(String string) {
        return tests.get(string);

    }

    public TestResult getRunningTest() {
        for (TestResult testResult : tests.values()) {
            if (!testResult.isFinished()) {
                return testResult;
            }
        }
        return null;
    }

    public Collection<TestResult> getTests() {
        return tests.values();

    }

    public String getSuitePath() {
        return suitePath;
    }

    public boolean hasFailed() {
        if (suiteFailed) {
            return true;
        }
        for (TestResult testResult : tests.values()) {
            if (testResult.hasFailed()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasError() {
        if (runtimeStartFailed || suiteError) {
            return true;
        }
        for (TestResult testResult : tests.values()) {
            if (testResult.hasError()) {
                return true;
            }
        }
        return false;
    }

    public boolean isIgnored() {
        if (tests.isEmpty()) {
            return false;
        }
        for (TestResult testResult : tests.values()) {
            if (!testResult.isIgnored()) {
                return false;
            }
        }
        return true;
    }

    public List<TestResult> getFailingTests() {
        List<TestResult> failingTests = new ArrayList<TestResult>();
        for (TestResult test : getTests()) {
            if (test.hasFailed()) {
                failingTests.add(test);
            }
        }
        return failingTests;
    }

    public List<TestResult> getErrorTests() {
        List<TestResult> errorTests = new ArrayList<TestResult>();
        for (TestResult test : getTests()) {
            if (test.hasError()) {
                errorTests.add(test);
            }
        }
        return errorTests;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return time;
    }

    public void setSuiteFailed(boolean suiteFailed) {
        this.suiteFailed = suiteFailed;
    }

    public boolean isSuiteFailed() {
        return suiteFailed;
    }

    public void setSuiteError(boolean suiteError) {
        this.suiteError = suiteError;
    }

    public boolean isSuiteError() {
        return suiteError;
    }
}