/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.Coverage;
import org.mule.MuleRuntimeDetector;
import org.mule.coverage.printer.ConsolePrinter;
import org.mule.coverage.printer.HtmlPrinter;
import org.mule.coverage.printer.JsonPrinter;
import org.mule.coverage.printer.MavenCoverageReportPrinter;
import org.mule.coverage.printer.SummaryConsolePrinter;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageManager {
    public static final String COVERAGE_NAME_FOLDER = "coverage";
    public static final String JSON_COVERAGE_NAME_FOLDER = "coverage-json";
    private Log log;
    private MuleRuntimeDetector muleRuntimeDetector = new MuleRuntimeDetector();
    private Coverage coverageConfiguration;
    private List<MavenCoverageReportPrinter> printers = new ArrayList<MavenCoverageReportPrinter>();
    private ApplicationCoverageReport coverageReport = null;
    private File coverageReportsFolder;

    public CoverageManager(Coverage coverageConfiguration, File coverageReportsFolder, Log log) {
        this.coverageConfiguration = coverageConfiguration;
        this.log = log;
        this.printers = new ArrayList<MavenCoverageReportPrinter>();
        this.coverageReportsFolder = coverageReportsFolder;
        this.setUpPrinters();
    }

    public void setMuleRuntimeDetector(MuleRuntimeDetector muleRuntimeDetector) {
        this.muleRuntimeDetector = muleRuntimeDetector;
    }

    private boolean isRunningOnEE() {
        return this.muleRuntimeDetector.isRunningOnEE();
    }

    public void setClasspath(List<String> classpath) {
        this.muleRuntimeDetector.setClasspath(classpath);
    }

    public Boolean shouldRunCoverage() {
        if (!this.isRunningOnEE()) {
            return false;
        }
        if (this.coverageConfiguration == null) {
            return false;
        }
        return this.coverageConfiguration.shouldRunCoverage();
    }

    public Set<String> getIgnoredFlows() {
        HashSet<String> ignoredFlows = new HashSet<String>();
        if (this.coverageConfiguration.getIgnoreFlows() != null) {
            ignoredFlows.addAll(new HashSet<String>(this.coverageConfiguration.getIgnoreFlows()));
        }
        return ignoredFlows;
    }

    public Boolean failBuild() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return false;
        }
        if (!this.coverageConfiguration.getFailBuild().booleanValue()) {
            return false;
        }
        if (this.coverageConfiguration.getRequiredApplicationCoverage() != -1.0 && this.getReport().getCoverage() < this.coverageConfiguration.getRequiredApplicationCoverage()) {
            return true;
        }
        if (this.coverageConfiguration.getRequiredResourceCoverage() != -1.0) {
            for (MuleResource mr : this.getReport().getResources()) {
                if (mr.getCoverage() == -1.0 || !(mr.getCoverage() < this.coverageConfiguration.getRequiredResourceCoverage())) continue;
                return true;
            }
        }
        if (this.coverageConfiguration.getRequiredFlowCoverage() != -1.0) {
            for (MuleResource mr : this.getReport().getResources()) {
                for (MuleFlow mf : mr.getFlows()) {
                    if (!(mf.getCoverage() < this.coverageConfiguration.getRequiredFlowCoverage())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void printReport() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return;
        }
        ApplicationCoverageReport report = this.getReport();
        if (report != null) {
            if (this.printers.size() > 0) {
                this.log.info((CharSequence)"Printing Coverage Report...");
                this.createCoverageReportFolder();
            } else {
                this.log.info((CharSequence)"No printers defined. The Coverage Report won't be printed.");
            }
            for (MavenCoverageReportPrinter printer : this.printers) {
                this.log.debug((CharSequence)("Executing: " + printer.getPrinterName() + " printer..."));
                printer.printReport(report);
            }
        } else {
            throw new IllegalStateException("Unable to generate Coverage Report for application. Coverage data is null.");
        }
        SummaryConsolePrinter defaultPrinter = new SummaryConsolePrinter(this.log);
        defaultPrinter.setRequiredApplicationCoverage(this.coverageConfiguration.getRequiredApplicationCoverage());
        defaultPrinter.setRequiredResourceCoverage(this.coverageConfiguration.getRequiredResourceCoverage());
        defaultPrinter.setRequiredFlowCoverage(this.coverageConfiguration.getRequiredFlowCoverage());
        defaultPrinter.setFailBuild(this.coverageConfiguration.getFailBuild());
        defaultPrinter.printReport(report);
    }

    private void setUpPrinters() {
        if (this.coverageConfiguration == null || this.coverageConfiguration.getFormats() == null) {
            return;
        }
        for (String printFormat : this.coverageConfiguration.getFormats()) {
            if ("Console".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new ConsolePrinter(this.log));
                continue;
            }
            if ("HTML".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new HtmlPrinter(this.coverageConfiguration, this.coverageReportsFolder.getAbsolutePath() + File.separator));
                continue;
            }
            if ("Json".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new JsonPrinter(this.coverageConfiguration, this.coverageReportsFolder.getAbsolutePath() + File.separator));
                continue;
            }
            this.log.debug((CharSequence)("No report format find for: " + printFormat));
        }
    }

    protected ApplicationCoverageReport getReport() {
        return this.coverageReport;
    }

    public void setReport(ApplicationCoverageReport coverageReport) {
        this.coverageReport = coverageReport;
    }

    private void createCoverageReportFolder() {
        this.log.debug((CharSequence)"Creating coverage folder...");
        new File(this.coverageReportsFolder, COVERAGE_NAME_FOLDER).mkdirs();
    }
}

