/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.printer;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.runner.model.RunResult;
import org.mule.runner.model.SuiteResult;
import org.mule.runner.model.TestResult;
import org.mule.runner.printer.ResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenResultPrinter
implements ResultPrinter {
    private static final String ERROR_TAG = "ERROR";
    private static final String FAILURE_TAG = "FAILED";
    private static final String SEPARATOR_TAG = " <<< ";
    private Log log;

    public MavenResultPrinter(Log log) {
        this.log = log;
    }

    @Override
    public void print(RunResult runResult) {
        this.log.info((CharSequence)"====================================================================================");
        this.log.info((CharSequence)"MUnit Run Summary                                                                   ");
        this.log.info((CharSequence)"====================================================================================");
        int testCount = runResult.getNumberOfTests();
        int errorCount = runResult.getNumberOfErrors();
        int failCount = runResult.getNumberOfFailures();
        int skipCount = runResult.getNumberOfIgnores();
        for (SuiteResult suiteResult : runResult.getSuites()) {
            List<TestResult> failingTests = suiteResult.getFailingTests();
            List<TestResult> errorTests = suiteResult.getErrorTests();
            this.printSuiteResult(suiteResult);
            this.printFailures(failingTests, this.log);
            this.printError(errorTests, this.log);
        }
        this.log.info((CharSequence)"\t");
        this.log.info((CharSequence)"====================================================================================");
        this.log.info((CharSequence)(" > Tests:   \t" + testCount));
        this.log.info((CharSequence)(" > Errors:  \t" + errorCount));
        this.log.info((CharSequence)(" > Failures:\t" + failCount));
        this.log.info((CharSequence)(" > Skipped: \t" + skipCount));
        this.log.info((CharSequence)"====================================================================================");
    }

    private void printSuiteResult(SuiteResult suiteResult) {
        String unsuccessfulTag = "";
        if (suiteResult.isSuiteFailed() || suiteResult.isSuiteError() || suiteResult.isRuntimeStartFailed()) {
            unsuccessfulTag = SEPARATOR_TAG;
            unsuccessfulTag = unsuccessfulTag + (suiteResult.isSuiteFailed() ? FAILURE_TAG : ERROR_TAG);
        }
        this.log.info((CharSequence)(" >> " + FilenameUtils.getName((String)suiteResult.getSuitePath()) + " test result: Tests: " + suiteResult.getNumberOfTests() + ", Errors: " + suiteResult.getNumberOfErrors() + ", Failures:" + suiteResult.getNumberOfFailures() + ", Skipped: " + suiteResult.getNumberOfIgnores() + unsuccessfulTag));
    }

    private void printFailures(List<TestResult> failingTests, Log log) {
        this.printUnsuccessfulTests(failingTests, FAILURE_TAG, log);
    }

    private void printError(List<TestResult> errorTests, Log log) {
        this.printUnsuccessfulTests(errorTests, ERROR_TAG, log);
    }

    private void printUnsuccessfulTests(List<TestResult> unsuccessfulTests, String unsuccessfulTag, Log log) {
        if (!unsuccessfulTests.isEmpty()) {
            for (TestResult result : unsuccessfulTests) {
                log.info((CharSequence)("\t --- " + result.getTestName() + SEPARATOR_TAG + unsuccessfulTag));
            }
        }
    }
}

