/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.maven.plugin.logging.Log;

import org.mule.munit.Coverage;
import org.mule.munit.coverage.printer.ConsolePrinter;
import org.mule.munit.coverage.printer.HtmlPrinter;
import org.mule.munit.coverage.printer.JsonPrinter;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.coverage.printer.SummaryConsolePrinter;

public class CoverageManager {

  public static final String COVERAGE_NAME_FOLDER = "coverage";
  public static final String JSON_COVERAGE_NAME_FOLDER = "coverage-json";

  private Log log;
  private File mavenSiteFolder;
  private File coverageReportsFolder;
  private Coverage coverageConfiguration;
  private List<MavenCoverageReportPrinter> printers = new ArrayList<>();

  // TODO disable due to MU-1091
  // private ApplicationCoverageReport coverageReport = null;

  public CoverageManager(Coverage coverageConfiguration, File mavenSiteFolder, File coverageReportsFolder, Log log) {
    this.coverageConfiguration = coverageConfiguration;
    this.log = log;
    this.printers = new ArrayList<>();

    this.mavenSiteFolder = mavenSiteFolder;
    this.coverageReportsFolder = coverageReportsFolder;

    this.setUpPrinters();
  }

  public Boolean shouldRunCoverage() {
    // TODO Re-enable MU-906
    // if (coverageConfiguration == null) {
    return false;
    // }

    // return coverageConfiguration.shouldRunCoverage();
  }

  public Set<String> getIgnoredFlows() {
    Set<String> ignoredFlows = new HashSet<>();
    if (coverageConfiguration.getIgnoreFlows() != null) {
      ignoredFlows.addAll(new HashSet<>(coverageConfiguration.getIgnoreFlows()));
    }
    return ignoredFlows;
  }

  public Boolean failBuild() {
    // TODO disable due to MU-1091
    // if (!shouldRunCoverage()) {
    // return false;
    // }
    //
    // if (!coverageConfiguration.getFailBuild()) {
    // return false;
    // }
    //
    // if (coverageConfiguration.getRequiredApplicationCoverage() != -1) {
    // if (getReport().getCoverage() < coverageConfiguration.getRequiredApplicationCoverage()) {
    // return true;
    // }
    // }
    //
    // if (coverageConfiguration.getRequiredResourceCoverage() != -1) {
    // for (MuleResource mr : getReport().getResources()) {
    // if (mr.getCoverage() != -1 && mr.getCoverage() < coverageConfiguration.getRequiredResourceCoverage()) {
    // return true;
    // }
    // }
    // }
    //
    // if (coverageConfiguration.getRequiredFlowCoverage() != -1) {
    // for (MuleResource mr : getReport().getResources()) {
    // for (MuleFlow mf : mr.getFlows()) {
    // if (mf.getCoverage() < coverageConfiguration.getRequiredFlowCoverage()) {
    // return true;
    // }
    // }
    // }
    // }

    return false;
  }

  public void printReport() {
    if (!shouldRunCoverage()) {
      return;
    }

    // TODO disable due to MU-1091
    // ApplicationCoverageReport report = getReport();
    // if (printers.size() > 0) {
    // log.info("Printing Coverage Report...");
    // createCoverageReportFolder();
    // } else {
    // log.info("No printers defined. The Coverage Report won't be printed.");
    // }
    //
    // for (MavenCoverageReportPrinter printer : printers) {
    // log.debug("Executing: " + printer.getPrinterName() + " printer...");
    // printer.printReport(report);
    // }

    SummaryConsolePrinter defaultPrinter = new SummaryConsolePrinter(log);
    defaultPrinter.setRequiredApplicationCoverage(coverageConfiguration.getRequiredApplicationCoverage());
    defaultPrinter.setRequiredResourceCoverage(coverageConfiguration.getRequiredResourceCoverage());
    defaultPrinter.setRequiredFlowCoverage(coverageConfiguration.getRequiredFlowCoverage());
    defaultPrinter.setFailBuild(coverageConfiguration.getFailBuild());
    // defaultPrinter.printReport(report);
  }

  private void setUpPrinters() {
    if (coverageConfiguration == null || coverageConfiguration.getFormats() == null) {
      return;
    }
    for (String printFormat : coverageConfiguration.getFormats()) {
      if (ConsolePrinter.PRINTER_NAME.toLowerCase().equals(printFormat.toLowerCase())) {
        printers.add(new ConsolePrinter(log));
        continue;
      }

      if (HtmlPrinter.PRINTER_NAME.toLowerCase().equals(printFormat.toLowerCase())) {
        printers.add(new HtmlPrinter(coverageConfiguration, mavenSiteFolder.getAbsolutePath() + File.separator));
        continue;
      }

      if (JsonPrinter.PRINTER_NAME.toLowerCase().equals(printFormat.toLowerCase())) {
        printers.add(new JsonPrinter(coverageConfiguration, coverageReportsFolder.getAbsolutePath() + File.separator));
        continue;
      }

      log.debug("No report format find for: " + printFormat);
    }
  }

  // TODO disable due to MU-1091
  // protected ApplicationCoverageReport getReport() {
  // return coverageReport;
  // }
  //
  // public void setReport(ApplicationCoverageReport coverageReport) {
  // this.coverageReport = coverageReport;
  // }

  private void createCoverageReportFolder() {
    log.debug("Creating coverage folder...");
    new File(coverageReportsFolder, COVERAGE_NAME_FOLDER).mkdirs();
  }
}
