/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer;

import java.io.File;

import org.mule.coverage.CoverageManager;
import org.mule.munit.Coverage;

public class JsonPrinter implements MavenCoverageReportPrinter {

  public static final String PRINTER_NAME = "Json";
  private final String reportFolderPath;
  private Coverage configuration;

  public JsonPrinter(Coverage configuration, String reportFolderBasePath) {
    this.configuration = configuration;
    this.reportFolderPath = reportFolderBasePath + CoverageManager.JSON_COVERAGE_NAME_FOLDER + File.separator;
  }

  public String getPrinterName() {
    return PRINTER_NAME;
  }

  // public void printReport(ApplicationCoverageReport report) {
  // try {
  // CoverageReportModel coverageReportModel = generateReportModel(report);
  // ObjectMapper mapper = new ObjectMapper();
  // new File(reportFolderPath).mkdir();
  // mapper.writerWithDefaultPrettyPrinter().writeValue(new File(reportFolderPath + "report.json"), coverageReportModel);
  // } catch (Exception e) {
  // e.printStackTrace();
  // }
  // }
  //
  // private CoverageReportModel generateReportModel(ApplicationCoverageReport report) {
  // CoverageReportModel coverageReportModel = new CoverageReportModel(report, configuration);
  // List<MuleResourceModel> files = new ArrayList<>();
  // for (MuleResource resource : report.getResources()) {
  // MuleResourceModel resourceModel = new MuleResourceModel(resource);
  // List<MuleFlowModel> flows = new ArrayList<>();
  // for (MuleFlow flow : resource.getFlows()) {
  // flows.add(new MuleFlowModel(flow));
  // }
  // resourceModel.setFlows(flows);
  // files.add(resourceModel);
  // }
  // coverageReportModel.setFiles(files);
  // return coverageReportModel;
  // }
}
