/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer;


import org.apache.commons.io.FileUtils;

import java.io.*;

public class ReportFileWriter {

  public String getHtmlFileName(String resourceName) {
    String htmlFileName = resourceName;
    htmlFileName = htmlFileName.substring(0, htmlFileName.indexOf(".xml")) + "-report" + ".html";
    return htmlFileName;
  }

  public void writeToFile(String filePath, String content) throws IOException {
    File file = new File(filePath);
    file.getParentFile().mkdirs();
    file.createNewFile();
    FileWriter fw = new FileWriter(file.getAbsoluteFile());

    BufferedWriter bw = new BufferedWriter(fw);
    bw.write(content);

    bw.flush();
    bw.close();
    fw.close();
  }

  public void copyFile(String originPath, String destinationPath) throws IOException {
    InputStream cssSource = this.getClass().getClassLoader().getResourceAsStream(originPath);
    File cssDestination = new File(destinationPath);
    FileUtils.copyInputStreamToFile(cssSource, cssDestination);
    cssSource.close();
  }
}
