/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer;

import java.text.DecimalFormat;
import java.text.NumberFormat;

import org.apache.maven.plugin.logging.Log;

public class SummaryConsolePrinter implements MavenCoverageReportPrinter {

  public static final String PRINTER_NAME = "summaryconsole";

  private Double requiredApplicationCoverage = Double.valueOf("-1");
  private Double requiredResourceCoverage = Double.valueOf("-1");
  private Double requiredFlowCoverage = Double.valueOf("-1");
  private Boolean failBuild = false;

  private Log log;

  public SummaryConsolePrinter(Log log) {
    this.log = log;
  }

  public void setRequiredApplicationCoverage(Double requiredApplicationCoverage) {
    this.requiredApplicationCoverage = requiredApplicationCoverage;
  }

  public void setRequiredResourceCoverage(Double requiredResourceCoverage) {
    this.requiredResourceCoverage = requiredResourceCoverage;
  }

  public void setRequiredFlowCoverage(Double requiredFlowCoverage) {
    this.requiredFlowCoverage = requiredFlowCoverage;
  }

  public void setFailBuild(Boolean failBuild) {
    this.failBuild = failBuild;
  }

  @Override
  public String getPrinterName() {
    return PRINTER_NAME;
  }

  // TODO disable due to MU-1091
  // @Override
  // public void printReport(ApplicationCoverageReport report) {
  // log.info("===============================================================================");
  // log.info("MUnit Coverage Summary");
  // log.info("===============================================================================");
  // log.info(" * Resources: " + report.getResources().size() + " - Flows: " + report.getApplicationFlowCount()
  // + " - Processors: " + report.getApplicationMessageProcessorCount());
  // if (report.getApplicationFlowCount() > 0) {
  // log.info(" * Application Coverage: " + formatCoverage(report.getCoverage()) + "%");
  // } else {
  // log.info(" * Application Coverage: N/A");
  // }
  // printCoverageWarnings(report);
  // }

  private String formatCoverage(Double coverage) {
    NumberFormat formatter = new DecimalFormat("#00.00");
    return formatter.format(coverage);
  }

  // TODO disable due to MU-1091
  // private void printCoverageWarnings(ApplicationCoverageReport report) {
  // List<String> warnings = new ArrayList<>();
  //
  // if (requiredApplicationCoverage != -1 && report.getApplicationFlowCount() > 0) {
  // if (report.getCoverage() < requiredApplicationCoverage) {
  // warnings.add(
  // " * Application coverage is below defined limit. Required: " + requiredApplicationCoverage + "% - Current: "
  // + formatCoverage(report.getCoverage()) + "%");
  // }
  // }
  //
  // if (requiredResourceCoverage != -1) {
  // for (MuleResource mr : report.getResources()) {
  // if (mr.getCoverage() != -1 && mr.getCoverage() < requiredResourceCoverage) {
  // warnings.add(
  // " * Resource " + mr.getName() + " coverage is below defined limit. Required: " + requiredResourceCoverage
  // + "% - Current: " + formatCoverage(mr.getCoverage()) + "%");
  // }
  // }
  // }
  //
  // if (requiredFlowCoverage != -1) {
  // for (MuleResource mr : report.getResources()) {
  // for (MuleFlow mf : mr.getFlows()) {
  // if (mf.getCoverage() < requiredFlowCoverage) {
  // warnings.add(
  // " * Flow: " + mr.getName() + " -> " + mf.getName() + " coverage is below defined limit. Required: "
  // + requiredFlowCoverage + "% - Current: " + formatCoverage(mf.getCoverage()) + "%");
  // }
  // }
  // }
  // }
  //
  // if (!warnings.isEmpty()) {
  // log.info("");
  // if (!failBuild) {
  // log.warn("----------------------------- WARNING --------------------------------------");
  // for (String w : warnings) {
  // log.warn(w);
  // }
  // } else {
  // log.error("------------------------------ FAILURE ---------------------------------------");
  // for (String w : warnings) {
  // log.error(w);
  // }
  // }
  // }
  // }

}
