/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo;

import org.apache.maven.plugin.logging.Log;
import org.mule.runner.handler.RunnerMessageHandler;
import org.mule.runner.handler.StandardOutputMessageHandler;
import org.mule.runner.handler.TestOutputMessageHandler;

/**
 * This is a factory of MessageHandler
 */
public class MessageHandlerFactory {

  private Log log;

  public MessageHandlerFactory(Log log) {
    this.log = log;
  }

  public RunnerMessageHandler create(Boolean redirectTestOutputToFile) {
    if (redirectTestOutputToFile) {
      return new TestOutputMessageHandler(log);
    } else {
      return new StandardOutputMessageHandler();
    }
  }

}
