/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.maven.plugin.logging.Log;
import org.mule.runner.printer.*;

public class ResultPrinterFactory {

  private Log log;

  protected File testOutputDirectory;
  protected File surefireReportsFolder;


  private Map<String, String> systemProperties;

  public ResultPrinterFactory(File testOutputDirectory, File surefireReportsFolder,
                              Map<String, String> systemProperties, Log log) {
    this.log = log;
    this.testOutputDirectory = testOutputDirectory;
    this.surefireReportsFolder = surefireReportsFolder;
    this.systemProperties = systemProperties;
  }

  public List<ResultPrinter> create(Boolean enableSurefireReports, Boolean redirectTestOutputToFile) {
    List<ResultPrinter> printers = new ArrayList<>();

    printers.add(new MavenResultPrinter(log));

    if (enableSurefireReports) {
      printers.addAll(getSurefireResultPrinters(redirectTestOutputToFile));
    }

    if (redirectTestOutputToFile) {
      printers.add(new TestOutputFilePrinter(testOutputDirectory, log));
    }

    return printers;
  }

  private List<ResultPrinter> getSurefireResultPrinters(Boolean redirectTestOutputToFile) {
    List<ResultPrinter> printers = new ArrayList<>();

    printers.add(new XmlResultPrinter(surefireReportsFolder, systemProperties, log));
    printers.add(new TextResultFilePrinter(surefireReportsFolder, log));
    if (redirectTestOutputToFile) {
      printers.add(new TestOutputFilePrinter(surefireReportsFolder, log));
    }

    return printers;
  }

}
