/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo.locators;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

public class TestSuiteFilesLocator implements FilesLocator {

  private static final String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";
  private static final String[] MUNIT_TEST_SUITE_FILE_EXTENSIONS = {"xml"};

  public List<File> locateFiles(File folder) {
    return FileUtils
        .listFiles(folder, MUNIT_TEST_SUITE_FILE_EXTENSIONS, true)
        .stream()
        .filter(this::isValidMunitTestSuiteFile)
        .collect(Collectors.toList());
  }

  private boolean isValidMunitTestSuiteFile(File file) {
    Scanner scanner = null;
    try {
      // TODO improve this lovely code
      scanner = new Scanner(file);
      while (scanner.hasNextLine()) {
        String line = scanner.nextLine();
        if (line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) {
          scanner.close();
          return true;
        }
      }

    } catch (FileNotFoundException e) {
      return false;
    } finally {
      if (null != scanner) {
        scanner.close();

      }
    }
    return false;
  }
}
