package org.mule.runner;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JVMStarter {

  private Log log;
  protected Commandline commandline = new Commandline();


  public JVMStarter(Log log) throws IOException {
    this.log = log;
  }

  public JVMStarter withJVM(String jvm) {
    commandline.setExecutable(jvm);
    return this;
  }

  public JVMStarter withJar(File jarFile) {
    commandline.createArg().setValue("-jar");
    commandline.createArg().setFile(jarFile);
    return this;
  }

  public JVMStarter withWorkingDirectory(File workingDirectory) {
    commandline.setWorkingDirectory(workingDirectory);
    return this;
  }

  public JVMStarter withArgLines(List<String> argLines) {
    for (String argLine : argLines) {
      commandline.createArg(true).setValue(argLine);
    }
    return this;
  }

  public JVMStarter withArgLines(Map<String, File> argLines) {
    for (Map.Entry<String, File> argLine : argLines.entrySet()) {
      commandline.createArg().setValue(argLine.getKey());
      commandline.createArg().setFile(argLine.getValue());
    }
    return this;
  }

  public JVMStarter withSystemProperties(Map<String, String> systemProperties) {
    for (Map.Entry<String, String> prop : systemProperties.entrySet()) {
      commandline.createArg(true).setValue("-D" + prop.getKey() + "=" + prop.getValue());
    }
    return this;
  }

  public JVMStarter addEnvironmentVariables(Map<String, String> environmentVariables) {
    for (Map.Entry<String, String> envVar : environmentVariables.entrySet()) {
      commandline.addEnvironment(envVar.getKey(), envVar.getValue());
    }
    return this;
  }

  public int execute(StreamConsumer outStreamConsumer, StreamConsumer errStreamConsumer) throws CommandLineException {
    log.debug("Executing command line: " + commandline);
    return CommandLineUtils.executeCommandLine(commandline, outStreamConsumer, errStreamConsumer);
  }

}
