package org.mule.runner.consumer;


import org.apache.maven.shared.utils.cli.CommandLineUtils;

public class ErrorStreamConsumer extends CommandLineUtils.StringStreamConsumer {

  private boolean redirectTestOutputToFile = false;

  public ErrorStreamConsumer(boolean redirectTestOutputToFile) {
    this.redirectTestOutputToFile = redirectTestOutputToFile;
  }

  @Override
  public void consumeLine(String line) {
    super.consumeLine(line);
    if (!redirectTestOutputToFile) {
      System.out.println(line);
    }
  }
}
