package org.mule.runner.model;

public class TestResult {

  private String testName;
  private boolean ignored;
  private boolean failed;
  private boolean error;
  private boolean finished;
  private long time;
  private String cause;

  public TestResult(String testName) {
    this.testName = testName;
  }

  public String getTestName() {
    return testName;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public void setIgnored(boolean ignored) {
    this.ignored = ignored;
  }

  public void setFailed(boolean failed) {
    this.failed = failed;
  }

  public void setError(boolean error) {
    this.error = error;
  }

  public boolean hasError() {
    return error;
  }

  public boolean hasFailed() {
    return failed;
  }

  public boolean isFinished() {
    return finished || failed || error;
  }

  public void setFinished(boolean finished) {
    this.finished = finished;
  }

  public String getCause() {
    return cause;
  }

  public void setCause(String cause) {
    this.cause = cause;
  }

  public void setTime(long time) {
    this.time = time;
  }

  public long getTime() {
    return time;
  }

}
