package org.mule.runner.printer;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.apache.maven.plugin.logging.Log;

public abstract class FileResultPrinter implements ResultPrinter {

  protected File reportBasePath;
  protected Log log;

  public FileResultPrinter(File reportBasePath, Log log) {
    this.reportBasePath = reportBasePath;
    this.log = log;
  }

  public PrintStream getResultPrintStream(String fileName) throws FileNotFoundException {
    File file = new File(reportBasePath, fileName);
    createFolderIfNotExists(file.getParentFile());
    return new PrintStream(new FileOutputStream(file));
  }

  private void createFolderIfNotExists(File parentFile) throws FileNotFoundException {
    boolean success = true;
    if (!parentFile.exists()) {
      success = parentFile.mkdirs();
    }
    if (!success) {
      throw new FileNotFoundException("Unable to create directory " + parentFile);
    }
  }

}
