/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.util;

import org.apache.maven.plugin.logging.Log;

import java.util.ArrayList;
import java.util.List;

import static java.util.Arrays.asList;
import static org.mule.munit.remote.classloading.ClassLoaderUtils.STARTER_JAR_FILE_NAME;

public class ArgLinesManager {

  public static final String JAVA_SYSTEM_CLASS_LOADER = "java.system.class.loader";

  private static final List<String> INVALID_ARG_LINES =
      asList("-jar", "-cp", "-classpath", "-D" + STARTER_JAR_FILE_NAME, "-D" + JAVA_SYSTEM_CLASS_LOADER);

  private Log log;
  private String starterJarFileName;
  private List<String> originalArgLines;

  public ArgLinesManager(List<String> originalArgLines, String starterJarFileName, Log log) {
    this.originalArgLines = originalArgLines;
    this.starterJarFileName = starterJarFileName;
    this.log = log;
  }

  public List<String> getEffectiveArgLines() {
    List<String> effectiveArgLines = new ArrayList<>();
    for (String argLine : originalArgLines) {
      if (filterArgLine(argLine)) {
        log.warn(argLine + " can not be set. We will ignore this argLine");
      } else {
        effectiveArgLines.add(argLine);
      }
    }
    addDefaultArgLines(effectiveArgLines);

    return effectiveArgLines;
  }

  private boolean filterArgLine(String argLine) {
    for (String invalidArgLine : INVALID_ARG_LINES) {
      if (argLine.startsWith(invalidArgLine)) {
        return true;
      }
    }
    return false;
  }

  private void addDefaultArgLines(List<String> effectiveArgLines) {
    effectiveArgLines.add("-D" + STARTER_JAR_FILE_NAME + "=" + starterJarFileName);
  }

}

