/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.printer.ConsolePrinter;
import org.mule.munit.coverage.printer.HtmlPrinter;
import org.mule.munit.coverage.printer.JsonPrinter;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.coverage.printer.SummaryConsolePrinter;

public class CoverageManager {
    public static final String COVERAGE_NAME_FOLDER = "coverage";
    public static final String JSON_COVERAGE_NAME_FOLDER = "coverage-json";
    private Log log;
    private File mavenSiteFolder;
    private File coverageReportsFolder;
    private Coverage coverageConfiguration;
    private List<MavenCoverageReportPrinter> printers = new ArrayList<MavenCoverageReportPrinter>();

    public CoverageManager(Coverage coverageConfiguration, File mavenSiteFolder, File coverageReportsFolder, Log log) {
        this.coverageConfiguration = coverageConfiguration;
        this.log = log;
        this.printers = new ArrayList<MavenCoverageReportPrinter>();
        this.mavenSiteFolder = mavenSiteFolder;
        this.coverageReportsFolder = coverageReportsFolder;
        this.setUpPrinters();
    }

    public Boolean shouldRunCoverage() {
        return false;
    }

    public Set<String> getIgnoredFlows() {
        HashSet<String> ignoredFlows = new HashSet<String>();
        if (this.coverageConfiguration.getIgnoreFlows() != null) {
            ignoredFlows.addAll(new HashSet<String>(this.coverageConfiguration.getIgnoreFlows()));
        }
        return ignoredFlows;
    }

    public Boolean failBuild() {
        return false;
    }

    public void printReport() {
        if (!this.shouldRunCoverage().booleanValue()) {
            return;
        }
        SummaryConsolePrinter defaultPrinter = new SummaryConsolePrinter(this.log);
        defaultPrinter.setRequiredApplicationCoverage(this.coverageConfiguration.getRequiredApplicationCoverage());
        defaultPrinter.setRequiredResourceCoverage(this.coverageConfiguration.getRequiredResourceCoverage());
        defaultPrinter.setRequiredFlowCoverage(this.coverageConfiguration.getRequiredFlowCoverage());
        defaultPrinter.setFailBuild(this.coverageConfiguration.getFailBuild());
    }

    private void setUpPrinters() {
        if (this.coverageConfiguration == null || this.coverageConfiguration.getFormats() == null) {
            return;
        }
        for (String printFormat : this.coverageConfiguration.getFormats()) {
            if ("Console".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new ConsolePrinter(this.log));
                continue;
            }
            if ("HTML".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new HtmlPrinter(this.coverageConfiguration, this.mavenSiteFolder.getAbsolutePath() + File.separator));
                continue;
            }
            if ("Json".toLowerCase().equals(printFormat.toLowerCase())) {
                this.printers.add(new JsonPrinter(this.coverageConfiguration, this.coverageReportsFolder.getAbsolutePath() + File.separator));
                continue;
            }
            this.log.debug((CharSequence)("No report format find for: " + printFormat));
        }
    }

    private void createCoverageReportFolder() {
        this.log.debug((CharSequence)"Creating coverage folder...");
        new File(this.coverageReportsFolder, COVERAGE_NAME_FOLDER).mkdirs();
    }
}

