/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.ToolchainManager;
import org.mule.coverage.CoverageManager;
import org.mule.munit.Coverage;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.mojo.JVMLocator;
import org.mule.munit.mojo.MessageHandlerFactory;
import org.mule.munit.mojo.ResultPrinterFactory;
import org.mule.munit.mojo.TestSuiteFileFilter;
import org.mule.munit.mojo.exceptions.MojoExecutionExceptionFactory;
import org.mule.munit.remote.ApplicationStructureGenerator;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.RemoteRunner;
import org.mule.munit.remote.config.RunConfiguration;
import org.mule.munit.util.JarFileFactory;
import org.mule.munit.util.RunConfigurationFactory;
import org.mule.runner.JVMStarter;
import org.mule.runner.consumer.ErrorStreamConsumer;
import org.mule.runner.consumer.RunnerStreamConsumer;
import org.mule.runner.model.RunResult;
import org.mule.runner.printer.ResultPrinter;
import org.mule.util.ArgLinesManager;
import org.mule.util.ClasspathManager;
import org.mule.util.properties.UserPropertiesBuilder;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class MUnitMojo
extends AbstractMojo {
    public static final String SINGLE_TEST_NAME_TOKEN = "#";
    public static final String SITE_MUNIT_DIRECTORY = "munit";
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    private static final String SKIP_ZIP_LOADING_PROPERTY = "skipZipLoading";
    private static final String ARG_TOKEN = "-";
    public static final String STARTER_CLASS_FILE = "munitstarter";
    private static final Class REMOTE_RUNNER_CLASS = RemoteRunner.class;
    private static final String RUN_CONFIGURATION_ARG = "-run_configuration";
    public static final String RUN_CONFIGURATION_JSON = "run-configuration.json";
    public static final String POM_XML_FILE_NAME = "pom.xml";
    public static final String MULE_APPLICATION_JSON_FILE_NAME = "mule-application.json";
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    protected List<String> classpathElements;
    @Parameter(property="munit.test")
    protected String munitTest;
    @Parameter(property="munit.tags")
    protected String munitTags;
    @Parameter(defaultValue="${skipMunitTests}")
    protected boolean skipMunitTests = false;
    @Parameter(property="system.property.variables")
    protected Map<String, String> systemPropertyVariables;
    @Parameter(property="environment.variables")
    protected Map<String, String> environmentVariables;
    @Parameter(property="dynamic.ports")
    protected List<String> dynamicPorts;
    @Parameter(property="munit.coverage")
    protected Coverage coverage;
    @Parameter(defaultValue="${munit.randomFailMessages}")
    private boolean randomFailMessages = false;
    @Parameter(property="argLines")
    protected List<String> argLines;
    @Parameter(property="additionalClasspathElements")
    protected List<String> additionalClasspathElements;
    @Parameter(property="sharedLibraries")
    protected List<String> sharedLibraries;
    @Parameter(property="classpathDependencyExcludes")
    protected List<String> classpathDependencyExcludes;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit")
    protected File munitTestsDirectory;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/")
    protected File munitReportsDirectory;
    @Parameter(defaultValue="${project.build.directory}/site/")
    protected File projectSiteDirectory;
    @Parameter(property="redirectTestOutputToFile", defaultValue="false")
    protected boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/output/")
    protected File testOutputDirectory;
    @Parameter(property="enableSurefireReports", defaultValue="true")
    protected boolean enableSurefireReports;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    protected File surefireReportsFolder;
    @Parameter
    protected String runtimeVersion;
    @Parameter(property="runtimeProduct", defaultValue="MULE_EE")
    protected String runtimeProduct;
    @Component
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    private File munitWorkingDirectory;
    protected TestSuiteFileFilter testSuiteFileFilter;
    protected MojoExecutionExceptionFactory exceptionFactory;
    protected ClasspathManager classpathManager;
    protected CoverageManager coverageManager;
    protected ResultPrinterFactory resultPrinterFactory;
    protected MessageHandlerFactory messageHandlerFactory;
    protected RunConfigurationFactory runConfigurationFactory;
    protected JVMLocator jvmLocator;
    protected JarFileFactory jarFileFactory;
    protected Map<String, String> effectiveSystemProperties;

    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!this.skipMunitTests) {
                this.init();
                this.doExecute();
            } else {
                this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipMunitTests] was set to true");
            }
        } else {
            this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipTests] was set to true");
        }
    }

    protected void init() throws MojoExecutionException {
        this.exceptionFactory = new MojoExecutionExceptionFactory(this.randomFailMessages);
        this.testSuiteFileFilter = new TestSuiteFileFilter(this.getLog(), this.munitTest);
        this.messageHandlerFactory = new MessageHandlerFactory(this.getLog());
        this.effectiveSystemProperties = this.getEffectiveSystemProperties();
        this.resultPrinterFactory = new ResultPrinterFactory(this.testOutputDirectory, this.surefireReportsFolder, this.effectiveSystemProperties, this.getLog());
        this.munitWorkingDirectory = this.createAndGetMunitWorkingDirectory();
        File applicationJsonFile = Paths.get(this.project.getBuild().getDirectory(), FolderNames.META_INF.value(), FolderNames.MULE_ARTIFACT.value(), MULE_APPLICATION_JSON_FILE_NAME).toFile();
        File workingDirMunitSrcFolder = Paths.get(this.munitWorkingDirectory.getAbsolutePath(), FolderNames.APPLICATION.value(), FolderNames.MULE.value(), FolderNames.MUNIT.value()).toFile();
        this.runConfigurationFactory = new RunConfigurationFactory(this.getLog(), this.munitTags, this.runtimeVersion, this.runtimeProduct, this.munitWorkingDirectory, this.testSuiteFileFilter, this.project, this.session, workingDirMunitSrcFolder, applicationJsonFile);
        this.jvmLocator = new JVMLocator(this.session, this.toolchainManager, this.getLog());
        this.classpathManager = new ClasspathManager(this.classpathElements, this.additionalClasspathElements, this.project.getArtifacts(), REMOTE_RUNNER_CLASS, this.getLog());
        this.jarFileFactory = new JarFileFactory();
        this.coverageManager = this.buildCoverageManager();
    }

    protected void doExecute() throws MojoExecutionException {
        this.generateApplicationStructure();
        RunConfiguration runConfiguration = this.runConfigurationFactory.createRunConfiguration(this.coverageManager);
        try {
            RunResult runResult;
            ErrorStreamConsumer errorStreamConsumer;
            RunnerStreamConsumer streamConsumer;
            if (runConfiguration == null) {
                this.getLog().info((CharSequence)"No Run configuration created not running MUnit ");
                return;
            }
            if (runConfiguration.getSuitePaths().isEmpty()) {
                this.getLog().info((CharSequence)"No MUnit suite files were found to run");
                return;
            }
            JVMStarter jvmStarter = this.createJVMStarter(runConfiguration);
            int result = jvmStarter.execute(streamConsumer = new RunnerStreamConsumer(this.messageHandlerFactory.create(this.redirectTestOutputToFile)), (StreamConsumer)(errorStreamConsumer = new ErrorStreamConsumer(this.redirectTestOutputToFile)));
            if (result == 0) {
                runResult = streamConsumer.getRunResult();
                for (ResultPrinter printer : this.resultPrinterFactory.create(this.enableSurefireReports, this.redirectTestOutputToFile)) {
                    printer.print(runResult);
                }
            } else {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoExecutionException(errorStreamConsumer.getOutput()));
            }
            boolean resultSuccess = !runResult.hasFailed();
            String stackTrace = runResult.getStackTrace();
            if (!resultSuccess) {
                throw this.exceptionFactory.buildException("Build Fail", (Throwable)new MojoExecutionException("MUnit Tests Failed\n" + stackTrace));
            }
            if (this.coverageManager.failBuild().booleanValue()) {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoFailureException("Coverage limits were not reached"));
            }
        }
        catch (IOException | CommandLineException e) {
            e.printStackTrace();
        }
    }

    private File createAndGetMunitWorkingDirectory() {
        File workingDirectory = new File(this.project.getBuild().getDirectory(), FolderNames.MUNIT_WORKING_DIR.value() + ARG_TOKEN + Long.toString(System.nanoTime()));
        workingDirectory.mkdir();
        return workingDirectory;
    }

    protected void generateApplicationStructure() throws MojoExecutionException {
        File sourceFolder = Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile();
        try {
            this.getLog().debug((CharSequence)("Attempting to create application structure source: " + sourceFolder.getAbsolutePath() + " - destination: " + this.munitWorkingDirectory.getAbsolutePath()));
            new ApplicationStructureGenerator(sourceFolder, this.munitWorkingDirectory).generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fail to create application structure", e);
        }
    }

    protected JVMStarter createJVMStarter(RunConfiguration runConfiguration) throws MojoExecutionException, IOException {
        if (!this.munitTestsDirectory.exists()) {
            this.getLog().warn((CharSequence)("The project has no " + this.munitTestsDirectory + " folder. Aborting MUnit test run."));
            return null;
        }
        this.getLog().debug((CharSequence)("MUnit root folder found at: " + this.munitTestsDirectory.getAbsolutePath()));
        String starterJarFileName = FileUtils.generateRandomFileName((String)STARTER_CLASS_FILE, (String)".jar");
        File jarFile = this.jarFileFactory.create(this.classpathManager.getEffectiveClasspath(), REMOTE_RUNNER_CLASS.getCanonicalName(), new File(this.project.getBuild().getDirectory()), starterJarFileName);
        JVMStarter jvmStarter = new JVMStarter(this.getLog()).withJVM(this.jvmLocator.locate()).withWorkingDirectory(this.getWorkingDirectory()).withJar(jarFile).withArgLines(this.getEffectiveArgLines(starterJarFileName)).withSystemProperties(this.effectiveSystemProperties).addEnvironmentVariables(this.environmentVariables);
        HashMap<String, File> fileArgLines = new HashMap<String, File>();
        fileArgLines.put(RUN_CONFIGURATION_ARG, this.saveRunConfigurationToFile(runConfiguration));
        jvmStarter.withArgLines(fileArgLines);
        return jvmStarter;
    }

    protected File saveRunConfigurationToFile(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = Paths.get(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), RUN_CONFIGURATION_JSON).toFile();
        FileWriter fileWriter = new FileWriter(runConfigurationFile);
        fileWriter.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)runConfiguration));
        fileWriter.flush();
        fileWriter.close();
        return runConfigurationFile;
    }

    protected List<String> getEffectiveArgLines(String starterJarFileName) {
        return new ArgLinesManager(this.argLines, starterJarFileName, this.getLog()).getEffectiveArgLines();
    }

    protected CoverageManager buildCoverageManager() {
        File mavenSiteFolder = this.getOrCreateSiteMunitDirectory();
        CoverageManager coverageManager = new CoverageManager(this.coverage, mavenSiteFolder, this.munitReportsDirectory, this.getLog());
        this.getLog().debug((CharSequence)String.format("Coverage Manager Build for project: %s - %s", this.project.getArtifactId(), this.project.getBasedir()));
        this.getLog().debug((CharSequence)this.project.getBuild().getDirectory());
        return coverageManager;
    }

    protected File getWorkingDirectory() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return new File(".");
    }

    private Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        effectiveSystemProperties.putAll(this.getUserSystemProperties());
        effectiveSystemProperties.put("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        return effectiveSystemProperties;
    }

    private Map<String, String> getUserSystemProperties() {
        return new UserPropertiesBuilder(this.project.getBuild().getDirectory(), this.getLog()).withSystemPropertyVariables(this.systemPropertyVariables).withDynamicPorts(this.dynamicPorts).withUserProperties(this.session != null ? this.session.getUserProperties() : null).build();
    }

    private File getOrCreateSiteMunitDirectory() {
        File munitSiteDirectory;
        if (!this.projectSiteDirectory.exists()) {
            this.projectSiteDirectory.mkdir();
        }
        if (!(munitSiteDirectory = new File(this.projectSiteDirectory, SITE_MUNIT_DIRECTORY)).exists()) {
            munitSiteDirectory.mkdir();
        }
        return munitSiteDirectory;
    }
}

