/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage.printer;

import java.io.File;
import java.io.IOException;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.coverage.printer.ReportFileWriter;

public class HtmlPrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "HTML";
    private static final String ASSETS_FOLDER = "assets/";
    private static final String STYLES_FOLDER = "styles/";
    private static final String SCRIPTS_FOLDER = "js/";
    private static final String ICONS_FOLDER = "icons/";
    private static final String FONTS_FOLDER = "fonts/";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary-template.html";
    private static final String RESOURCE_TEMPLATE_FILE_NAME = "resource-template.html";
    private static final String MULESOFT_STYLES = "mulesoft-styles.css";
    private static final String TSORTER_STYLES = "tsorter.css";
    private static final String MULESOFT_ICON = "icons/004_logo.svg";
    private static final String MULESOFT_ICON_TTF = "fonts/muleicons.ttf";
    private static final String TSORTER_SCRIPT = "tsorter.min.js";
    private final String reportFolderPath;
    private Coverage configuration;
    private ReportFileWriter reportFileWriter = new ReportFileWriter();

    public HtmlPrinter(Coverage configuration, String reportFolderBasePath) {
        this.configuration = configuration;
        this.reportFolderPath = reportFolderBasePath + "coverage" + File.separator;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    public void setReportFileWriter(ReportFileWriter reportFileWriter) {
        this.reportFileWriter = reportFileWriter;
    }

    private void addAssets() {
        this.addStyles();
        this.addScripts();
    }

    private void addStyles() {
        try {
            String stylesPath = this.reportFolderPath + ASSETS_FOLDER + STYLES_FOLDER;
            this.reportFileWriter.copyFile(MULESOFT_STYLES, stylesPath + MULESOFT_STYLES);
            this.reportFileWriter.copyFile(MULESOFT_ICON, stylesPath + MULESOFT_ICON);
            this.reportFileWriter.copyFile(MULESOFT_ICON_TTF, stylesPath + MULESOFT_ICON_TTF);
            this.reportFileWriter.copyFile(TSORTER_STYLES, stylesPath + TSORTER_STYLES);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addScripts() {
        try {
            String scriptsPath = this.reportFolderPath + ASSETS_FOLDER + SCRIPTS_FOLDER;
            this.reportFileWriter.copyFile(TSORTER_SCRIPT, scriptsPath + TSORTER_SCRIPT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

