/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.runner.printer.MavenResultPrinter;
import org.mule.runner.printer.ResultPrinter;
import org.mule.runner.printer.TestOutputFilePrinter;
import org.mule.runner.printer.TextResultFilePrinter;
import org.mule.runner.printer.XmlResultPrinter;

public class ResultPrinterFactory {
    private Log log;
    protected File testOutputDirectory;
    protected File surefireReportsFolder;
    private Map<String, String> systemProperties;

    public ResultPrinterFactory(File testOutputDirectory, File surefireReportsFolder, Map<String, String> systemProperties, Log log) {
        this.log = log;
        this.testOutputDirectory = testOutputDirectory;
        this.surefireReportsFolder = surefireReportsFolder;
        this.systemProperties = systemProperties;
    }

    public List<ResultPrinter> create(Boolean enableSurefireReports, Boolean redirectTestOutputToFile) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new MavenResultPrinter(this.log));
        if (enableSurefireReports.booleanValue()) {
            printers.addAll(this.getSurefireResultPrinters(redirectTestOutputToFile));
        }
        if (redirectTestOutputToFile.booleanValue()) {
            printers.add(new TestOutputFilePrinter(this.testOutputDirectory, this.log));
        }
        return printers;
    }

    private List<ResultPrinter> getSurefireResultPrinters(Boolean redirectTestOutputToFile) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new XmlResultPrinter(this.surefireReportsFolder, this.systemProperties, this.log));
        printers.add(new TextResultFilePrinter(this.surefireReportsFolder, this.log));
        if (redirectTestOutputToFile.booleanValue()) {
            printers.add(new TestOutputFilePrinter(this.surefireReportsFolder, this.log));
        }
        return printers;
    }
}

