/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.reflection;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.reflection.ReflectionUtilsException;

public class MethodInvoker {
    private final Object instance;
    private final String methodName;
    private final List<Object> values = new ArrayList<Object>();
    private final List<Class<?>> types = new ArrayList();

    public MethodInvoker(Object instance, String methodName) {
        Preconditions.checkNotNull((Object)instance, (Object)"The object instance must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)methodName), (Object)"The method name must not be null nor empty");
        this.instance = instance;
        this.methodName = methodName;
    }

    public void clear() {
        this.types.clear();
        this.values.clear();
    }

    public MethodInvoker with(Class<?> type, Object value) {
        this.types.add(type);
        this.values.add(value);
        return this;
    }

    public Object invoke() throws ReflectionUtilsException {
        if (this.types.isEmpty() && this.values.isEmpty()) {
            return this.invokeInstanceNoParameters();
        }
        return this.invokeInstanceWithParameters();
    }

    private Object invokeInstanceNoParameters() throws ReflectionUtilsException {
        Class<?> klass = this.instance.getClass();
        try {
            Method method = klass.getMethod(this.methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ReflectionUtilsException("Fail to invoke method " + klass.getCanonicalName() + "#" + this.methodName, e);
        }
    }

    private Object invokeInstanceWithParameters() throws ReflectionUtilsException {
        Class<?> klass = this.instance.getClass();
        try {
            Method method = klass.getMethod(this.methodName, this.getTypesArray(this.types));
            return method.invoke(this.instance, this.getParametersArray(this.values));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ReflectionUtilsException("Fail to invoke method " + klass.getCanonicalName() + "#" + this.methodName, e);
        }
    }

    private Class<?>[] getTypesArray(List<? extends Class<?>> listOfTypes) {
        int i = 0;
        Class[] types = new Class[listOfTypes.size()];
        Iterator<Class<?>> iterator = listOfTypes.iterator();
        while (iterator.hasNext()) {
            Class<?> c;
            types[i] = c = iterator.next();
        }
        return types;
    }

    private Object[] getParametersArray(List<Object> listOfParameters) {
        int i = 0;
        Object[] types = new Object[listOfParameters.size()];
        Iterator<Object> iterator = listOfParameters.iterator();
        while (iterator.hasNext()) {
            Object c;
            types[i] = c = iterator.next();
        }
        return types;
    }
}

