/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.coverage.CoverageManager;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.mojo.TestSuiteFileFilter;
import org.mule.munit.mojo.locators.Log4J2ConfigurationLocator;
import org.mule.munit.mojo.locators.TestSuiteFilesLocator;
import org.mule.munit.remote.config.ContainerConfiguration;
import org.mule.munit.remote.config.CoverageConfiguration;
import org.mule.munit.remote.config.MavenConfiguration;
import org.mule.munit.remote.config.NotifierConfiguration;
import org.mule.munit.remote.config.NotifierParameter;
import org.mule.munit.remote.config.RunConfiguration;
import org.mule.munit.remote.notifiers.ConsoleNotifier;
import org.mule.munit.util.MulePropertiesLoader;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public class RunConfigurationFactory {
    private Log log;
    private String munitTags;
    private String testToRunName;
    private String runtimeVersion;
    private String runtimeProduct;
    private File munitWorkingDirectory;
    private TestSuiteFileFilter testSuiteFileFilter;
    protected MavenProject project;
    protected MavenSession session;
    private File munitSrcFolder;
    private File applicationJsonFile;

    public RunConfigurationFactory(Log log, String munitTags, String runtimeVersion, String runtimeProduct, File munitWorkingDirectory, TestSuiteFileFilter testSuiteFileFilter, MavenProject project, MavenSession session, File munitSrcFolder, File applicationJsonFile) {
        this.log = log;
        this.munitTags = munitTags;
        this.runtimeVersion = runtimeVersion;
        this.runtimeProduct = runtimeProduct;
        this.munitWorkingDirectory = munitWorkingDirectory;
        this.project = project;
        this.session = session;
        this.testSuiteFileFilter = testSuiteFileFilter;
        this.testToRunName = testSuiteFileFilter.getTestNameRegEx();
        this.munitSrcFolder = munitSrcFolder;
        this.applicationJsonFile = applicationJsonFile;
    }

    public RunConfiguration createRunConfiguration(CoverageManager coverageManager) throws MojoExecutionException {
        String runToken = UUID.randomUUID().toString();
        CoverageConfiguration coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(coverageManager.shouldRunCoverage()).withApplicationPaths(this.getConfigResources()).withIgnoredFlowNames(coverageManager.getIgnoredFlows()).buid();
        ArrayList<NotifierParameter> consoleParameters = new ArrayList<NotifierParameter>();
        consoleParameters.add(new NotifierParameter("runToken", String.class.getCanonicalName(), runToken));
        NotifierConfiguration consoleNotifierConfiguration = new NotifierConfiguration.NotifierConfigurationBuilder().withClazz(ConsoleNotifier.class.getCanonicalName()).withParameters(consoleParameters).build();
        ArrayList<NotifierConfiguration> notifierConfigurations = new ArrayList<NotifierConfiguration>();
        notifierConfigurations.add(consoleNotifierConfiguration);
        MavenConfiguration mavenConfiguration = new MavenConfiguration.MavenConfigurationBuilder().withMavenRepositoryDirectoryPath(this.session.getLocalRepository().getBasedir()).withSettingsXmlFilePath(this.session.getRequest().getUserSettingsFile().getAbsolutePath()).withForcePolicyUpdate(Boolean.valueOf(true)).build();
        ContainerConfiguration containerConfiguration = new ContainerConfiguration.ContainerConfigurationBuilder().withRuntimeId(this.getRuntimeVersion()).withProduct(this.runtimeProduct).withMunitWorkingDirectoryPath(this.munitWorkingDirectory.getAbsolutePath()).withLog4JConfigurationFilePath(this.getLog4JConfigurationFilePath()).withMavenConfiguration(mavenConfiguration).build();
        RunConfiguration.RunConfigurationBuilder builder = new RunConfiguration.RunConfigurationBuilder();
        builder.withRunToken(runToken).withProjectName(this.project.getName()).withTags((Set)(this.munitTags == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(this.munitTags.split(","))))).withTestNames(StringUtils.isBlank((CharSequence)this.testToRunName) ? Collections.emptySet() : Sets.newHashSet((Object[])this.testToRunName.split(","))).withSuitePaths(this.locateMunitTestSuites()).withNotifierConfigurations(notifierConfigurations).withCoverageConfiguration(coverageConfiguration).withContainerConfiguration(containerConfiguration);
        return builder.build();
    }

    private String getLog4JConfigurationFilePath() {
        return this.getLog4JConfigurationFile().isPresent() ? this.getLog4JConfigurationFile().get().getAbsolutePath() : "";
    }

    private Optional<File> getLog4JConfigurationFile() {
        List<File> files = new Log4J2ConfigurationLocator(this.log).locateFiles(new File(this.project.getBuild().getDirectory()));
        return files.isEmpty() ? Optional.empty() : Optional.of(files.get(0));
    }

    private Set<String> locateMunitTestSuites() {
        return new TestSuiteFilesLocator().locateFiles(this.munitSrcFolder).stream().filter(suiteFile -> this.testSuiteFileFilter.shouldFilter(suiteFile.getName())).map(suiteFile -> this.munitSrcFolder.toURI().relativize(suiteFile.toURI()).toASCIIString()).collect(Collectors.toSet());
    }

    private String getConfigResources() {
        MulePropertiesLoader propertiesLoader = new MulePropertiesLoader(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getTestOutputDirectory(), this.log);
        return propertiesLoader.getConfigResources();
    }

    private String getRuntimeVersion() throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        try {
            this.runtimeVersion = this.getMuleApplicationModel().getMinMuleVersion();
            this.log.debug((CharSequence)("Runtime version to " + this.runtimeVersion + " obtained from the mule-application.json file"));
            return this.runtimeVersion;
        }
        catch (IOException e) {
            String message = "Fail to obtain Runtime version from mule-application.json";
            this.log.error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    private MuleApplicationModel getMuleApplicationModel() throws IOException {
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)this.applicationJsonFile));
    }
}

