/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.mule.runner.model.SuiteResult;
import org.mule.runner.model.TestResult;

public class RunResult {
    private SuiteResult currentSuite = null;
    private String stackTrace = "";
    private Map<String, List<String>> suiteOutputs = Collections.emptyMap();
    private boolean runFinished = false;
    private boolean coverageEnabled = true;
    private boolean unexpectedError = false;
    private Map<String, SuiteResult> suites = new HashMap<String, SuiteResult>();

    public void testSuiteStartFailed(String suiteFullPath, String stackTrace) {
        SuiteResult suite = new SuiteResult();
        suite.setRuntimeStartFailed(true);
        suite.setCause(stackTrace);
        suite.setSuiteFinished(true);
        suite.setSuitePath(suiteFullPath);
        this.suites.put(suiteFullPath, suite);
        suite.setTime(0L);
    }

    public void testSuiteStarted(String suiteFullPath) {
        SuiteResult suite = new SuiteResult();
        suite.setSuitePath(suiteFullPath);
        this.suites.put(suiteFullPath, suite);
        this.currentSuite = suite;
    }

    public void testStarted(String suiteFullPath, String testName) {
        this.suites.get(suiteFullPath).add(testName, new TestResult(testName));
    }

    public void testFailure(String suiteFullPath, String testName, String stackTrace, long elapsedTime) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setFailed(true);
        test.setCause(stackTrace);
        test.setTime(elapsedTime);
    }

    public void testError(String suiteFullPath, String testName, String stackTrace, long elapsedTime) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setError(true);
        test.setCause(stackTrace);
        test.setTime(elapsedTime);
    }

    public void testFinished(String suiteFullPath, String testName, long elapsedTime) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setFinished(true);
        test.setTime(elapsedTime);
    }

    public void testIgnored(String suiteFullPath, String testName, long elapsedTime) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setIgnored(true);
        test.setTime(elapsedTime);
    }

    public void suiteFinished(String suiteFullPath, long elapsedTime) {
        this.suites.get(suiteFullPath).setSuiteFinished(true);
        this.currentSuite = null;
        this.suites.get(suiteFullPath).setTime(elapsedTime);
    }

    public void suiteFailure(String suiteFullPath, String stackTrace) {
        this.suites.get(suiteFullPath).setSuiteFailed(true);
        this.suites.get(suiteFullPath).setCause(stackTrace);
    }

    public void suiteError(String suiteFullPath, String stackTrace) {
        this.suites.get(suiteFullPath).setSuiteError(true);
        this.suites.get(suiteFullPath).setCause(stackTrace);
    }

    public void unexpectedError(String stackTrace) {
        this.currentSuite = null;
        this.unexpectedError = true;
        this.runFinished = true;
        this.stackTrace = stackTrace;
    }

    public Collection<SuiteResult> getSuites() {
        return this.suites.values();
    }

    public boolean isRunFinished() {
        return this.runFinished;
    }

    public void setRunFinished(boolean runFinished) {
        this.runFinished = runFinished;
    }

    public SuiteResult getSuite(String suiteName) {
        return this.suites.get(suiteName);
    }

    public int getNumberOfTests() {
        return this.summarize(SuiteResult::getNumberOfTests);
    }

    public int getNumberOfIgnores() {
        return this.summarize(SuiteResult::getNumberOfIgnores);
    }

    public int getNumberOfErrors() {
        return this.summarize(SuiteResult::getNumberOfErrors);
    }

    public int getNumberOfFailures() {
        return this.summarize(SuiteResult::getNumberOfFailures);
    }

    private int summarize(ToIntFunction<SuiteResult> predicate) {
        return this.getSuites().stream().mapToInt(predicate).sum();
    }

    public SuiteResult getCurrentSuite() {
        return this.currentSuite;
    }

    public Map<String, List<String>> getSuiteOutputs() {
        return this.suiteOutputs;
    }

    public void setSuiteOutputs(Map<String, List<String>> suiteOutputs) {
        this.suiteOutputs = suiteOutputs;
    }

    public boolean hasFailed() {
        return this.unexpectedError || this.suites.values().stream().anyMatch(suite -> suite.hasFailed() || suite.hasError());
    }

    public void setCoverageEnabled(boolean runCoverage) {
        this.coverageEnabled = runCoverage;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }
}

