/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

public class ClasspathManager {
    private List<String> additionalClasspathElements;
    private List<String> classpathElements;
    private Set<Artifact> artifacts;
    private Class runnerClass;
    private Log log;

    public ClasspathManager(List<String> classpathElements, List<String> additionalClasspathElements, Set artifacts, Class runnerClass, Log log) {
        this.classpathElements = classpathElements;
        this.additionalClasspathElements = additionalClasspathElements;
        this.artifacts = artifacts;
        this.runnerClass = runnerClass;
        this.log = log;
    }

    public List<String> getEffectiveClasspath() {
        ArrayList<String> effectiveClasspath = new ArrayList<String>();
        effectiveClasspath.addAll(this.classpathElements);
        this.addRunnerClassDependency(effectiveClasspath);
        this.addAdditionalClasspathElements(effectiveClasspath);
        this.log.debug((CharSequence)"Classpath: ");
        for (String classpathEntry : effectiveClasspath) {
            this.log.debug((CharSequence)classpathEntry);
        }
        return effectiveClasspath;
    }

    private void addRunnerClassDependency(List<String> effectiveClasspath) {
        if (this.runnerClass != null) {
            String runnerClassDependency = this.runnerClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            effectiveClasspath.add(runnerClassDependency);
            this.log.debug((CharSequence)String.format("Runner dependency added: %s", runnerClassDependency));
        } else {
            this.log.info((CharSequence)"The runner class provided is null");
        }
    }

    private void addAdditionalClasspathElements(List<String> effectiveClasspath) {
        if (this.additionalClasspathElements != null) {
            for (String classpathEntry : this.additionalClasspathElements) {
                if (this.validateClasspathEntry(classpathEntry)) {
                    effectiveClasspath.add(classpathEntry);
                    continue;
                }
                this.log.warn((CharSequence)String.format("Unable to add entry %s to classpath because it does not exist", classpathEntry));
            }
        }
    }

    protected boolean validateClasspathEntry(String classpathEntry) {
        return new File(classpathEntry).exists();
    }
}

