/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public abstract class PropertiesFileBuilder {
    private String propertiesFileFolderPath;
    protected Log log;

    public PropertiesFileBuilder(String propertiesFileFolderPath, Log log) {
        this.propertiesFileFolderPath = propertiesFileFolderPath;
        this.log = log;
    }

    public Map<String, String> savePropertiesFileIfRequired(Map<String, String> effectiveSystemProperties) {
        if (StringUtils.isNotBlank((CharSequence)this.propertiesFileFolderPath)) {
            try {
                String propertiesFilePath = this.propertiesFileFolderPath + File.separator + this.getFileName();
                this.savePropertiesFile(effectiveSystemProperties, this.propertiesFileFolderPath, this.getFileName());
                HashMap<String, String> fileSystemProperties = new HashMap<String, String>();
                this.setSystemPropertiesFile(propertiesFilePath, fileSystemProperties);
                return fileSystemProperties;
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Fail to save " + this.getFileName() + " sending properties as parameter"), (Throwable)e);
            }
        } else {
            this.log.error((CharSequence)"Save system properties to file disabled");
        }
        return effectiveSystemProperties;
    }

    private void savePropertiesFile(Map<String, String> propertiesMap, String path, String name) throws IOException {
        Properties props = new Properties();
        propertiesMap.forEach(props::setProperty);
        File file = new File(path, name);
        FileOutputStream out = new FileOutputStream(file);
        props.store(out, "");
        ((OutputStream)out).close();
        file.deleteOnExit();
    }

    private void setSystemPropertiesFile(String systemPropertiesFile, Map<String, String> props) {
        this.log.debug((CharSequence)String.format("Setting [%s] to %s", this.getFileProperty(), systemPropertiesFile));
        props.put(this.getFileProperty(), systemPropertiesFile);
    }

    protected abstract String getFileProperty();

    protected abstract String getFileName();
}

