/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.util.properties.PropertiesFileBuilder;

public class UserPropertiesBuilder
extends PropertiesFileBuilder {
    private static final int MIN_PORT_NUMBER = 40000;
    private static final int MAX_PORT_NUMBER = 50000;
    private static final Collection<String> INVALID_SYSTEM_PROPERTIES = Arrays.asList("java.library.path", "file.encoding", "jdk.map.althashing.threshold", "java.system.class.loader", "munit.classloader.starter.jar.file.name");
    public static final String MULE_TESTING_MODE = "mule.testingMode";
    public static final String MUNIT_RUNNER_SERVER_PORT = "munit.server.port";
    public static final String USER_SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String USER_SYSTEM_PROPERTIES_FILE_NAME = "user.system.properties";
    private Map<String, String> systemPropertyVariables = Collections.emptyMap();
    private Properties userProperties;
    private List<String> dynamicPorts = Collections.emptyList();

    public UserPropertiesBuilder(String propertiesFileFolderPath, Log log) {
        super(propertiesFileFolderPath, log);
    }

    public UserPropertiesBuilder withSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
        return this;
    }

    public UserPropertiesBuilder withDynamicPorts(List<String> dynamicPorts) {
        this.dynamicPorts = dynamicPorts;
        return this;
    }

    public UserPropertiesBuilder withUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public Map<String, String> build() {
        Map<String, String> effectiveSystemProperties = new HashMap<String, String>();
        this.setSystemPropertyVariables(effectiveSystemProperties);
        this.setDynamicPorts(effectiveSystemProperties);
        this.setMunitRunnerServer(effectiveSystemProperties);
        this.setStopLicenseCheck(effectiveSystemProperties);
        this.setUserSystemProperties(effectiveSystemProperties);
        this.removeInvalidSystemProperties(effectiveSystemProperties);
        effectiveSystemProperties = this.savePropertiesFileIfRequired(effectiveSystemProperties);
        return effectiveSystemProperties;
    }

    @Override
    protected String getFileProperty() {
        return USER_SYSTEM_PROPERTIES_FILE;
    }

    @Override
    protected String getFileName() {
        return USER_SYSTEM_PROPERTIES_FILE_NAME;
    }

    private void setStopLicenseCheck(Map<String, String> props) {
        this.log.debug((CharSequence)"Avoid license check for Mule EE components...");
        props.put(MULE_TESTING_MODE, "true");
    }

    private void setMunitRunnerServer(Map<String, String> props) {
        FreePortFinder portFinder = new FreePortFinder(40000, 50000);
        Integer port = portFinder.find();
        this.log.debug((CharSequence)("Setting port for the MUnit runner server : " + port));
        props.put(MUNIT_RUNNER_SERVER_PORT, String.valueOf(port));
    }

    private void setSystemPropertyVariables(Map<String, String> systemProperties) {
        if (this.systemPropertyVariables != null) {
            systemProperties.putAll(this.systemPropertyVariables);
            this.log.debug((CharSequence)("Adding System Property Variables : " + this.systemPropertyVariables));
        }
    }

    private void setUserSystemProperties(Map<String, String> systemProperties) {
        if (this.userProperties != null) {
            for (Map.Entry<Object, Object> prop : this.userProperties.entrySet()) {
                Object key = prop.getKey();
                Object value = prop.getValue();
                if (!(key instanceof String) || !(value instanceof String)) continue;
                systemProperties.put(prop.getKey().toString(), prop.getValue().toString());
                this.log.debug((CharSequence)String.format("Setting System Property [%s] to %s", key, value));
            }
        }
    }

    private void setDynamicPorts(Map<String, String> systemProperties) {
        if (this.dynamicPorts != null) {
            this.log.info((CharSequence)"Acquiring dynamic ports...");
            FreePortFinder portFinder = new FreePortFinder(40000, 50000);
            for (String portPlaceHolder : this.dynamicPorts) {
                Integer dynamicPort = portFinder.find();
                systemProperties.put(portPlaceHolder, dynamicPort.toString());
                this.log.debug((CharSequence)String.format("Dynamic port [%s] set to: [%s]", portPlaceHolder, dynamicPort));
            }
            this.log.info((CharSequence)"Dynamic port definition [DONE]");
        }
    }

    private void removeInvalidSystemProperties(Map<String, String> effectiveSystemProperties) {
        INVALID_SYSTEM_PROPERTIES.stream().filter(effectiveSystemProperties::containsKey).forEach(invalidProp -> {
            effectiveSystemProperties.remove(invalidProp);
            this.log.warn((CharSequence)(invalidProp + " cannot be set as system property, use <argLine>-D" + invalidProp + "=...</argLine> instead"));
        });
    }
}

