/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.handler;

import org.mule.munit.runner.model.RunResult;
import org.mule.munit.runner.model.SuiteResult;

/**
 * <p>
 * Interface that handles Test Run Events
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public interface RunnerMessageHandler {

  void handleSuiteStartFailure(SuiteResult suiteResult);

  void handleSuiteStart(String suiteFullPath);

  void handleSuiteFinished(SuiteResult suiteResult);

  void handleStandardOutputLine(String line);

  void handleRunResult(RunResult runResult);

  void handleSuiteFailure(SuiteResult suite);

  void handleSuiteError(SuiteResult suite);

  void handleUnexpectedError(String stackTrace);

}
