/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage.printer;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.coverage.printer.model.CoverageReportModel;
import org.mule.munit.coverage.printer.model.MuleFlowModel;
import org.mule.munit.coverage.printer.model.MuleResourceModel;
import org.mule.munit.remote.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.report.model.MuleFlow;
import org.mule.munit.remote.coverage.report.model.MuleResource;

public class JsonPrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "Json";
    private final File reportFile;
    private Coverage configuration;

    public JsonPrinter(Coverage configuration, File reportFile) {
        Preconditions.checkNotNull((Object)reportFile, (Object)"The report path cannot be null");
        Preconditions.checkNotNull((Object)configuration, (Object)"The coverage configuration cannot be null");
        this.configuration = configuration;
        this.reportFile = reportFile;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            CoverageReportModel coverageReportModel = this.generateReportModel(report);
            this.reportFile.createNewFile();
            FileWriter fileWriter = new FileWriter(this.reportFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)coverageReportModel, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CoverageReportModel generateReportModel(ApplicationCoverageReport report) {
        CoverageReportModel coverageReportModel = new CoverageReportModel(report, this.configuration);
        ArrayList<MuleResourceModel> files = new ArrayList<MuleResourceModel>();
        for (MuleResource resource : report.getResources()) {
            MuleResourceModel resourceModel = new MuleResourceModel(resource);
            ArrayList<MuleFlowModel> flows = new ArrayList<MuleFlowModel>();
            for (MuleFlow flow : resource.getFlows()) {
                flows.add(new MuleFlowModel(flow));
            }
            resourceModel.setFlows(flows);
            files.add(resourceModel);
        }
        coverageReportModel.setFiles(files);
        return coverageReportModel;
    }
}

