/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.consumer;

import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.MessageField;
import org.mule.munit.common.protocol.message.RunMessageParser;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.handler.RunnerMessageHandler;
import org.mule.munit.runner.model.RunResult;

public class RunnerStreamConsumer
implements StreamConsumer {
    private RunResult runResult = new RunResult();
    private RunnerMessageHandler runnerMessageHandler;
    private RunMessageParser runnerParser;

    public RunnerStreamConsumer(RunnerMessageHandler runnerMessageHandler) {
        this.runnerMessageHandler = runnerMessageHandler;
        this.runnerParser = new RunMessageParser((RunEventListener)new RunStreamConsumerEventListener());
    }

    public void consumeLine(String s) {
        if (s.startsWith(MessageField.FIELD_TOKEN)) {
            this.handleProtocolLine(s.replace(MessageField.FIELD_TOKEN, "").replaceAll(MessageField.NEW_LINE_ESCAPE_TOKEN, System.lineSeparator()));
        } else {
            this.runnerMessageHandler.handleStandardOutputLine(s);
        }
    }

    protected void handleProtocolLine(String message) {
        this.runnerParser.parseAndNotify(message);
    }

    public RunResult getRunResult() {
        this.runnerMessageHandler.handleRunResult(this.runResult);
        return this.runResult;
    }

    private void notifyBeforeOrAfterSuite(String currentSuite, String stackTrace, TestStatus status) {
        switch (status) {
            case ERROR: {
                this.runResult.suiteError(currentSuite, stackTrace);
                this.runnerMessageHandler.handleSuiteFailure(this.runResult.getSuite(currentSuite));
                break;
            }
            case FAILURE: {
                this.runResult.suiteFailure(currentSuite, stackTrace);
                this.runnerMessageHandler.handleSuiteFailure(this.runResult.getSuite(currentSuite));
            }
        }
    }

    private class RunStreamConsumerEventListener
    implements RunEventListener {
        private String currentSuite;

        private RunStreamConsumerEventListener() {
        }

        public void notifyRunFinish() {
            RunnerStreamConsumer.this.runResult.setRunFinished(true);
        }

        public void notifyCoverageReport(String coverageReportJson) {
            RunnerStreamConsumer.this.runResult.setCoverageReport(coverageReportJson);
        }

        public void notifySuiteStart(String suite, int numberOfTests) {
            this.currentSuite = suite;
            RunnerStreamConsumer.this.runResult.testSuiteStarted(suite);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteStart(suite);
        }

        public void notifyContainerFailure(String suite, String stackTrace) {
            RunnerStreamConsumer.this.runResult.testSuiteStartFailed(suite, stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteStartFailure(RunnerStreamConsumer.this.runResult.getSuite(suite));
        }

        public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
            RunnerStreamConsumer.this.notifyBeforeOrAfterSuite(this.currentSuite, stackTrace, status);
        }

        public void notifyTestStart(String name) {
            RunnerStreamConsumer.this.runResult.testStarted(this.currentSuite, name);
        }

        public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
            switch (status) {
                case SUCCESS: {
                    RunnerStreamConsumer.this.runResult.testFinished(this.currentSuite, name, elapsedTime);
                    break;
                }
                case FAILURE: {
                    RunnerStreamConsumer.this.runResult.testFailure(this.currentSuite, name, stackTrace, elapsedTime);
                    break;
                }
                case IGNORED: {
                    RunnerStreamConsumer.this.runResult.testIgnored(this.currentSuite, name, elapsedTime);
                    break;
                }
                case ERROR: {
                    RunnerStreamConsumer.this.runResult.testError(this.currentSuite, name, stackTrace, elapsedTime);
                }
            }
        }

        public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
            RunnerStreamConsumer.this.notifyBeforeOrAfterSuite(this.currentSuite, stackTrace, status);
        }

        public void notifySuiteEnd(String suite, long elapsedTime) {
            RunnerStreamConsumer.this.runResult.suiteFinished(suite, elapsedTime);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteFinished(RunnerStreamConsumer.this.runResult.getSuite(this.currentSuite));
        }

        public void notifyUnexpectedError(String stackTrace) {
            RunnerStreamConsumer.this.runResult.unexpectedError(stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleUnexpectedError(stackTrace);
        }

        public void notifySuiteUnexpectedError(String stackTrace) {
            RunnerStreamConsumer.this.runResult.unexpectedError(stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleUnexpectedError(stackTrace);
        }
    }
}

