/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.printer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.runner.model.RunResult;
import org.mule.munit.runner.printer.FileResultPrinter;

public class TestOutputFilePrinter
extends FileResultPrinter {
    private static final String TXT_REPORT_HEADER = "munit.";

    public TestOutputFilePrinter(File reportBasePath, Log log) {
        super(reportBasePath, log);
    }

    @Override
    public void print(RunResult runResult) {
        Map<String, List<String>> suiteOutputs = runResult.getSuiteOutputs();
        try {
            for (Map.Entry<String, List<String>> suiteOutput : suiteOutputs.entrySet()) {
                String suiteRelativePath = suiteOutput.getKey();
                String suiteReportName = suiteRelativePath.replace("/", ".");
                suiteReportName = suiteReportName.replace(".xml", "-output.txt");
                PrintStream out = this.getResultPrintStream(TXT_REPORT_HEADER + suiteReportName);
                this.log.debug((CharSequence)String.format("Writing %s file in %s", suiteReportName, this.reportBasePath));
                for (String outputLine : suiteOutput.getValue()) {
                    out.println(outputLine);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

