/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ArgLinesManager {
    public static final String JAVA_SYSTEM_CLASS_LOADER = "java.system.class.loader";
    private static final List<String> INVALID_ARG_LINES = Arrays.asList("-jar", "-cp", "-classpath", "-Dmunit.classloader.starter.jar.file.name", "-Djava.system.class.loader");
    private Log log;
    private String starterJarFileName;
    private List<String> originalArgLines;

    public ArgLinesManager(List<String> originalArgLines, String starterJarFileName, Log log) {
        this.originalArgLines = originalArgLines;
        this.starterJarFileName = starterJarFileName;
        this.log = log;
    }

    public List<String> getEffectiveArgLines() {
        ArrayList<String> effectiveArgLines = new ArrayList<String>();
        for (String argLine : this.originalArgLines) {
            if (this.filterArgLine(argLine)) {
                this.log.warn((CharSequence)(argLine + " can not be set. We will ignore this argLine"));
                continue;
            }
            effectiveArgLines.add(argLine);
        }
        this.addDefaultArgLines(effectiveArgLines);
        return effectiveArgLines;
    }

    private boolean filterArgLine(String argLine) {
        for (String invalidArgLine : INVALID_ARG_LINES) {
            if (!argLine.startsWith(invalidArgLine)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultArgLines(List<String> effectiveArgLines) {
        effectiveArgLines.add("-Dmunit.classloader.starter.jar.file.name=" + this.starterJarFileName);
    }
}

