/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;

public class CoordinateFilter {
    public static final String MAVEN_COORDINATES_SEPARATOR = ":";
    public static final String WILD_CARD = "*";
    public static final int MAX_TOKENS = 5;
    private String groupId = "*";
    private String artifactId = "*";
    private String extension = "*";
    private String classifier = "*";
    private String version = "*";

    private CoordinateFilter() {
    }

    public static CoordinateFilter of(String coordinate) {
        StringTokenizer stringTokenizer = new StringTokenizer(coordinate, MAVEN_COORDINATES_SEPARATOR);
        if (stringTokenizer.countTokens() > 5) {
            throw new IllegalArgumentException(coordinate + " is invalid: Maven coordinates should be in the form of <groupId>:<artifactId>:<extension>:<classifier>:<version>");
        }
        return new CoordinateFilterBuilder().withGroupId(CoordinateFilter.getNextToken(stringTokenizer)).withArtifactId(CoordinateFilter.getNextToken(stringTokenizer)).withExtension(CoordinateFilter.getNextToken(stringTokenizer)).withClassifier(CoordinateFilter.getNextToken(stringTokenizer)).withVersion(CoordinateFilter.getNextToken(stringTokenizer)).build();
    }

    public boolean accepts(Artifact artifact) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion()};
        String[] patternTokens = this.getPatternTokens();
        boolean matched = true;
        for (int i = 0; matched && i < tokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    public String getMuleCoordinatesFormat() {
        return Stream.of(this.getPatternTokens()).collect(Collectors.joining(MAVEN_COORDINATES_SEPARATOR));
    }

    private boolean matches(String token, String pattern) {
        if (WILD_CARD.equals(pattern)) {
            return true;
        }
        return pattern.equals(token);
    }

    private String[] getPatternTokens() {
        return new String[]{this.groupId, this.artifactId, this.extension, this.classifier, this.version};
    }

    private static String getNextToken(StringTokenizer stringTokenizer) {
        return stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : WILD_CARD;
    }

    public static class CoordinateFilterBuilder {
        private static final String GROUP_ID = "group id";
        private static final String ARTIFACT_ID = "artifact id";
        private static final String VERSION = "version";
        private static final String CLASSIFIER = "classifier";
        private static final String EXTENSION = "extension";
        private CoordinateFilter coordinateFilter = new CoordinateFilter();

        public CoordinateFilterBuilder withGroupId(String groupId) {
            this.validateIsNotNull(groupId, GROUP_ID);
            this.coordinateFilter.groupId = groupId;
            return this;
        }

        public CoordinateFilterBuilder withArtifactId(String artifactId) {
            this.validateIsNotNull(artifactId, ARTIFACT_ID);
            this.coordinateFilter.artifactId = artifactId;
            return this;
        }

        public CoordinateFilterBuilder withClassifier(String classifier) {
            this.validateIsNotNull(classifier, CLASSIFIER);
            this.coordinateFilter.classifier = classifier;
            return this;
        }

        public CoordinateFilterBuilder withVersion(String version) {
            this.validateIsNotNull(version, VERSION);
            this.coordinateFilter.version = version;
            return this;
        }

        public CoordinateFilterBuilder withExtension(String extension) {
            this.validateIsNotNull(extension, EXTENSION);
            this.coordinateFilter.extension = extension;
            return this;
        }

        public CoordinateFilter build() {
            return this.coordinateFilter;
        }

        private void validateIsNotNull(String value, String fieldId) {
            Validate.notNull((Object)value, (String)"Coordinate field '%s' cannot be null", (Object[])new Object[]{fieldId});
        }
    }
}

