/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.Coverage;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.mojo.TestSuiteFileFilter;
import org.mule.munit.mojo.locators.Log4J2ConfigurationLocator;
import org.mule.munit.mojo.locators.TestSuiteFilesLocator;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.MavenConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.NotifierParameter;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;
import org.mule.munit.remote.notifiers.ConsoleNotifier;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public class RunConfigurationFactory {
    public static final String RUN_TOKEN_CONSOLE_PARAMETER = "runToken";
    private Log log;
    private String munitTags;
    private Boolean skipAfterFailure;
    private TestSuiteFileFilter testSuiteFileFilter;
    private String runtimeVersion;
    private String runtimeProduct;
    private File munitSrcFolder;
    private File munitWorkingDirectory;
    private File muleArtifactJsonFile;
    private Coverage coverage;
    private String pluginVersion;
    protected MavenProject project;
    protected MavenSession session;

    public RunConfigurationFactory(Log log, String munitTest, String munitTags, Boolean skipAfterFailure, String runtimeVersion, String runtimeProduct, File munitWorkingDirectory, Coverage coverage, String pluginVersion, MavenProject project, MavenSession session) {
        Preconditions.checkNotNull((Object)log, (Object)"The log must not be null");
        Preconditions.checkNotNull((Object)skipAfterFailure, (Object)"The skipAfterFailure must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeProduct), (Object)"The runtimeProduct must not be null nor empty");
        Preconditions.checkNotNull((Object)munitWorkingDirectory, (Object)"The munitWorkingDirectory must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginVersion), (Object)"The pluginVersion must not be null nor empty");
        Preconditions.checkNotNull((Object)project, (Object)"The project must not be null");
        Preconditions.checkNotNull((Object)session, (Object)"The session must not be null");
        this.log = log;
        this.munitTags = munitTags;
        this.skipAfterFailure = skipAfterFailure;
        this.testSuiteFileFilter = new TestSuiteFileFilter(log, munitTest);
        this.runtimeVersion = runtimeVersion;
        this.runtimeProduct = runtimeProduct;
        this.munitWorkingDirectory = munitWorkingDirectory;
        this.munitSrcFolder = munitWorkingDirectory.toPath().resolve(project.getArtifactId()).resolve(FolderNames.MUNIT.value()).toFile();
        this.muleArtifactJsonFile = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json").toFile();
        this.coverage = coverage;
        this.pluginVersion = pluginVersion;
        this.project = project;
        this.session = session;
    }

    public RunConfiguration createRunConfiguration() throws MojoExecutionException {
        String runToken = UUID.randomUUID().toString();
        ArrayList<NotifierParameter> consoleParameters = new ArrayList<NotifierParameter>();
        consoleParameters.add(new NotifierParameter(RUN_TOKEN_CONSOLE_PARAMETER, String.class.getCanonicalName(), runToken));
        NotifierConfiguration consoleNotifierConfiguration = new NotifierConfiguration.NotifierConfigurationBuilder().withClazz(ConsoleNotifier.class.getCanonicalName()).withParameters(consoleParameters).build();
        ArrayList<NotifierConfiguration> notifierConfigurations = new ArrayList<NotifierConfiguration>();
        notifierConfigurations.add(consoleNotifierConfiguration);
        MavenConfiguration mavenConfiguration = new MavenConfiguration.MavenConfigurationBuilder().withMavenRepositoryDirectoryPath(this.session.getLocalRepository().getBasedir()).withSettingsXmlFilePath(this.session.getRequest().getUserSettingsFile().getAbsolutePath()).withForcePolicyUpdate(Boolean.valueOf(true)).build();
        ContainerConfiguration.ContainerConfigurationBuilder containerConfigurationBuilder = new ContainerConfiguration.ContainerConfigurationBuilder().withRuntimeId(this.getRuntimeVersion()).withProduct(this.runtimeProduct).withMunitWorkingDirectoryPath(this.munitWorkingDirectory.getAbsolutePath()).withLog4JConfigurationFilePath(this.getLog4JConfigurationFilePath()).withMavenConfiguration(mavenConfiguration);
        Boolean shouldRunCoverage = new CoverageAuthorizator(this.coverage, this.runtimeProduct).shouldRunCoverage();
        CoverageConfiguration coverageConfiguration = this.buildCoverageConfiguration(shouldRunCoverage);
        if (shouldRunCoverage.booleanValue()) {
            String coveragePluginVersion = this.pluginVersion;
            ServerPluginConfiguration coveragePluginConfiguration = this.getCoverageServerPluginConfiguration(coveragePluginVersion);
            containerConfigurationBuilder.withServerPluginConfiguration(coveragePluginConfiguration);
        }
        ContainerConfiguration containerConfiguration = containerConfigurationBuilder.build();
        RunConfiguration.RunConfigurationBuilder builder = new RunConfiguration.RunConfigurationBuilder();
        String testToRunName = this.testSuiteFileFilter.getTestNameRegEx();
        builder.withRunToken(runToken).withProjectName(this.project.getArtifactId()).withTags((Set)(this.munitTags == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(this.munitTags.split(","))))).withSkipAfterFailure(this.skipAfterFailure).withTestNames(StringUtils.isBlank((CharSequence)testToRunName) ? Collections.emptySet() : Sets.newHashSet((Object[])testToRunName.split(","))).withSuitePaths(this.locateMunitTestSuites()).withNotifierConfigurations(notifierConfigurations).withCoverageConfiguration(coverageConfiguration).withContainerConfiguration(containerConfiguration);
        return builder.build();
    }

    private CoverageConfiguration buildCoverageConfiguration(Boolean shouldRunCoverage) {
        Set coverageIgnoreFlows = this.coverage != null ? this.coverage.getIgnoreFlows() : Collections.emptySet();
        Set coverageIgnoreFiles = this.coverage != null ? this.coverage.getIgnoreFiles() : Collections.emptySet();
        CoverageConfiguration coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(shouldRunCoverage).withSuitePaths(this.locateMunitTestSuites()).withIgnoredFiles(coverageIgnoreFiles).withIgnoredFlowNames(coverageIgnoreFlows).build();
        return coverageConfiguration;
    }

    private ServerPluginConfiguration getCoverageServerPluginConfiguration(String coveragePluginVersion) {
        return new ServerPluginConfiguration.ServerPluginConfigurationBuilder().withGroupId("com.mulesoft.munit.plugins").withArtifactId("munit-coverage-plugin").withVersion(coveragePluginVersion).withClassifier("plugin").withType("zip").build();
    }

    private String getLog4JConfigurationFilePath() {
        return this.getLog4JConfigurationFile().isPresent() ? this.getLog4JConfigurationFile().get().getAbsolutePath() : "";
    }

    private Optional<File> getLog4JConfigurationFile() {
        List<File> files = new Log4J2ConfigurationLocator(this.log).locateFiles(new File(this.project.getBuild().getDirectory()));
        return files.isEmpty() ? Optional.empty() : Optional.of(files.get(0));
    }

    private Set<String> locateMunitTestSuites() {
        return new TestSuiteFilesLocator().locateFiles(this.munitSrcFolder).stream().map(suiteFile -> this.munitSrcFolder.toURI().relativize(suiteFile.toURI()).toASCIIString()).filter(suitePath -> this.testSuiteFileFilter.shouldFilter((String)suitePath)).collect(Collectors.toSet());
    }

    private String getRuntimeVersion() throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        try {
            this.runtimeVersion = this.getMuleApplicationModel().getMinMuleVersion();
            this.log.debug((CharSequence)("Runtime version to " + this.runtimeVersion + " obtained from the " + "mule-artifact.json" + " file"));
            return this.runtimeVersion;
        }
        catch (IOException e) {
            String message = "Fail to obtain Runtime version from mule-artifact.json";
            this.log.error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    private MuleApplicationModel getMuleApplicationModel() throws IOException {
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)this.muleArtifactJsonFile));
    }
}

