/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer;


import static com.google.common.base.Preconditions.checkNotNull;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

/**
 * <p>
 * Handles report file creation and generates the HTML report file name
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ReportFileWriter {

  public String getHtmlFileName(String resourceName) {
    String htmlFileName = resourceName;
    htmlFileName = htmlFileName.substring(0, htmlFileName.indexOf(".xml")) + "-report" + ".html";
    return htmlFileName;
  }

  public void writeToFile(File file, String content) throws IOException {
    checkNotNull(file, "File cannot be null");
    file.getParentFile().mkdirs();
    file.createNewFile();
    FileWriter fw = new FileWriter(file.getAbsoluteFile());

    BufferedWriter bw = new BufferedWriter(fw);
    bw.write(content);

    bw.flush();
    bw.close();
    fw.close();
  }

  public void copyFile(String originPath, File destination) throws IOException {
    InputStream resource = this.getClass().getClassLoader().getResourceAsStream(originPath);
    FileUtils.copyInputStreamToFile(resource, destination);
  }
}
