/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer.model;

import org.mule.munit.remote.coverage.report.model.MuleFlow;
import org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType;

/**
 * <p>
 * Model that represents a Mule Flow.
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MuleFlowModel {

  private String name;
  private ComponentType type;
  private double coverage;
  private int messageProcessorCount;
  private int coveredProcessorCount;

  public MuleFlowModel(MuleFlow flow) {
    this.coverage = flow.getCoverage();
    this.name = flow.getName();
    this.type = flow.getType();
    this.messageProcessorCount = flow.getLocations().size();
    this.coveredProcessorCount = flow.getCoveredLocations().size();
  }

  public double getCoverage() {
    return coverage;
  }

  public void setCoverage(double coverage) {
    this.coverage = coverage;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ComponentType getType() {
    return type;
  }

  public void setType(ComponentType type) {
    this.type = type;
  }

  public int getProcessorCount() {
    return messageProcessorCount;
  }

  public void setProcessorCount(int processorCount) {
    this.messageProcessorCount = processorCount;
  }

  public int getMessageProcessorCount() {
    return coveredProcessorCount;
  }

  public void setCoveredProcessorCount(int coveredProcessorCount) {
    this.coveredProcessorCount = coveredProcessorCount;
  }
}
