/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage.printer.model;


import java.util.ArrayList;
import java.util.List;

import org.mule.munit.remote.coverage.report.model.MuleResource;

/**
 * <p>
 * Model that represents a Mule Config File.
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MuleResourceModel {

  private String name;
  private int flowCount;
  private double coverage;
  private int processorCount;
  private double weight;
  private List<MuleFlowModel> flows = new ArrayList<>();

  public MuleResourceModel(MuleResource resource) {
    this.coverage = resource.getCoverage();
    this.name = resource.getName();
    this.flowCount = resource.getFlows().size();
    this.processorCount = resource.getMessageProcessorCount();
    this.weight = resource.getWeight();
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public double getCoverage() {
    return coverage;
  }

  public void setCoverage(double coverage) {
    this.coverage = coverage;
  }

  public List<MuleFlowModel> getFlows() {
    return flows;
  }

  public void setFlows(List<MuleFlowModel> flows) {
    this.flows = flows;
  }

  public int getFlowCount() {
    return flowCount;
  }

  public void setFlowCount(int flowCount) {
    this.flowCount = flowCount;
  }

  public int getProcessorCount() {
    return processorCount;
  }

  public void setProcessorCount(int processorCount) {
    this.processorCount = processorCount;
  }

  public double getWeight() {
    return weight;
  }

  public void setWeight(double weight) {
    this.weight = weight;
  }
}
