/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.handler;

/**
 * <p>
 * RunnerMessageHandler that prints to Standard Output from the new jvm to the Standard Output of the Mojo
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class StandardOutputMessageHandler implements RunnerMessageHandler {

  @Override
  public void handleStandardOutputLine(String message) {
    System.out.println(message);
  }

}
