/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.printer;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.apache.maven.plugin.logging.Log;

/**
 * <p>
 * Abstract class that prints a test run result to a file
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public abstract class FileResultPrinter implements ResultPrinter {

  protected File reportBasePath;
  protected Log log;

  public FileResultPrinter(File reportBasePath, Log log) {
    this.reportBasePath = reportBasePath;
    this.log = log;
  }

  public PrintStream getResultPrintStream(String fileName) throws FileNotFoundException {
    File file = new File(reportBasePath, fileName);
    createFolderIfNotExists(file.getParentFile());
    return new PrintStream(new FileOutputStream(file));
  }

  private void createFolderIfNotExists(File parentFile) throws FileNotFoundException {
    boolean success = true;
    if (!parentFile.exists()) {
      success = parentFile.mkdirs();
    }
    if (!success) {
      throw new FileNotFoundException("Unable to create directory " + parentFile);
    }
  }

}
